/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.teleport;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TpaDenyCommand
extends CommandManager {
    public TpaDenyCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_TPA_DENY)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_TPA_DENY)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        Player target = player.getServer().getPlayer(args[0]);
        if (target == null) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
            return true;
        }
        if (this.listUtil.getTpa().containsKey(player.getUniqueId()) && !this.listUtil.getTpaHere().containsKey(player.getUniqueId())) {
            if (!this.listUtil.getTpa().containsValue(target.getUniqueId())) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TPA_DENY_NO_REQUEST));
                return true;
            }
            Player targetDeny = player.getServer().getPlayer(this.listUtil.getTpa().get(player.getUniqueId()));
            if (targetDeny == null) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                return true;
            }
            this.listUtil.getTpa().remove(player.getUniqueId(), targetDeny.getUniqueId());
            this.sendMessage((CommandSender)targetDeny, this.message.getString(Messages.COMMAND_TPA_DENY_PLAYER).replace("[PLAYER]", player.getName()));
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TPA_DENY_TARGET).replace("[PLAYER]", targetDeny.getName()));
        } else if (!this.listUtil.getTpa().containsKey(player.getUniqueId()) && this.listUtil.getTpaHere().containsKey(player.getUniqueId())) {
            if (!this.listUtil.getTpaHere().containsValue(target.getUniqueId())) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TPA_DENY_NO_REQUEST));
                return true;
            }
            Player targetDeny = player.getServer().getPlayer(this.listUtil.getTpaHere().get(player.getUniqueId()));
            if (targetDeny == null) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                return true;
            }
            this.listUtil.getTpaHere().remove(player.getUniqueId(), targetDeny.getUniqueId());
            this.sendMessage((CommandSender)targetDeny, this.message.getString(Messages.COMMAND_TPA_DENY_PLAYER).replace("[PLAYER]", player.getName()));
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TPA_DENY_TARGET).replace("[PLAYER]", targetDeny.getName()));
        } else {
            this.listUtil.getTpa().remove(player.getUniqueId());
            this.listUtil.getTpaHere().remove(player.getUniqueId());
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TPA_DENY_NO_REQUEST));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompletePlayers(sender, args, 1);
    }
}

