/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.teleport;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TpCommand
extends CommandManager {
    public TpCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_TP)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_TP)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length == 1) {
            Player target = player.getServer().getPlayer(args[0]);
            if (target == null) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                return true;
            }
            player.teleport((Entity)target);
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TP_TO_TARGET).replace("[PLAYER]", target.getName()));
        } else if (args.length == 2) {
            Player target1 = player.getServer().getPlayer(args[0]);
            if (target1 == null) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                return true;
            }
            Player target2 = player.getServer().getPlayer(args[1]);
            if (target2 == null) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
                return true;
            }
            target1.teleport((Entity)target2);
            this.sendMessage((CommandSender)target1, this.message.getString(Messages.COMMAND_TP_TO_TARGET).replace("[PLAYER]", target2.getName()));
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_TP_TARGET_TO_TARGET).replace("[PLAYER1]", target1.getName()).replace("[PLAYER2]", target2.getName()));
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return this.tabCompletePlayers(sender, args);
        }
        if (args.length == 2) {
            return this.tabCompletePlayers(sender, args);
        }
        return Collections.emptyList();
    }
}

