/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.inventories;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderChestCommand
extends CommandManager {
    public EnderChestCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ENDER_CHEST_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ENDER_CHEST_COMMAND)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length == 0) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ENDER_CHEST_USE)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_ENDER_CHEST_USE)) {
                return true;
            }
            this.enderChest.createEnderChestGUI(player);
        } else if (args.length == 1) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ENDER_CHEST_OTHER)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_ENDER_CHEST_OTHER)) {
                return true;
            }
            Player target = player.getServer().getPlayer(args[0]);
            if (target == null) {
                OfflinePlayer offlinePlayer = player.getServer().getOfflinePlayer(args[0]);
                if (offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore()) {
                    this.enderChest.createEnderChestGUI(player, offlinePlayer);
                } else {
                    this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                }
                return true;
            }
            this.enderChest.createEnderChestGUI(player, target);
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompletePlayers(sender, args, 1);
    }
}

