/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.homes;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveHomeCommand
extends CommandManager {
    public RemoveHomeCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_REMOVE_HOME)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_REMOVE_HOME)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        if (!this.homes.hasHome(player.getUniqueId(), args[0])) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_NOT_EXIST_HOME).replace("[HOME]", args[0]));
            return true;
        }
        this.homes.removeHome(player.getUniqueId(), args[0]);
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_REMOVE_HOME).replace("[HOME]", args[0]));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabComplete(this.homes.getHomeList(), args, 1);
    }
}

