/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.homes;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddHomeCommand
extends CommandManager {
    public AddHomeCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ADD_HOME)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ADD_HOME)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        if (this.homes.hasHome(player.getUniqueId(), args[0])) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_EXIST_HOME).replace("[HOME]", args[0]));
            return true;
        }
        if (this.homeLimit(player)) {
            this.homes.addHome(player, args[0]);
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_ADD_HOME).replace("[HOME]", args[0]));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }

    private boolean homeLimit(Player player) {
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_HOME_UNLIMITED))) {
            return true;
        }
        int limit = player.hasPermission(this.config.getString(Configs.PERMISSION_HOME_LIMIT_TEAM)) ? this.config.getInt(Configs.HOME_LIMIT_TEAM) : (player.hasPermission(this.config.getString(Configs.PERMISSION_HOME_LIMIT_RANK)) ? this.config.getInt(Configs.HOME_LIMIT_RANK) : this.config.getInt(Configs.HOME_LIMIT_DEFAULT));
        if (this.homes.getHomeList().size() >= limit) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_HOME_LIMIT));
            return false;
        }
        return true;
    }
}

