/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SellCommand
extends CommandManager {
    public SellCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_SELL)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_SELL)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 1) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        ItemStack itemStack = player.getItemInHand();
        if (itemStack.getType().equals((Object)Material.AIR)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_AIR));
            return true;
        }
        switch (args[0]) {
            case "hand": {
                this.sellHand(player, itemStack);
                break;
            }
            case "price": {
                this.sellPrice(player, itemStack);
                break;
            }
            default: {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabComplete(Arrays.asList("hand", "price"), args, 1);
    }

    private void sellHand(Player player, ItemStack itemStack) {
        if (this.config.getBoolean(Configs.MATERIAL_CASE)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_USE).replace("[MONEY]", this.decimalFormat.format(this.itemValue.sellItem(player, itemStack))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)).replace("[ITEM]", itemStack.getType().name()).toLowerCase());
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_USE).replace("[MONEY]", this.decimalFormat.format(this.itemValue.sellItem(player, itemStack))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)).replace("[ITEM]", itemStack.getType().name().toUpperCase()));
        }
    }

    private void sellPrice(Player player, ItemStack itemStack) {
        BigDecimal price = BigDecimal.valueOf(this.itemValue.getValue(itemStack.getType()));
        BigDecimal result = price.multiply(BigDecimal.valueOf(itemStack.getAmount()));
        if (this.config.getBoolean(Configs.MATERIAL_CASE)) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_PRICE).replace("[ITEM]", itemStack.getType().name().toLowerCase()).replace("[MONEY]", this.decimalFormat.format(this.itemValue.getValue(itemStack.getType()))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)).replace("[PREFIX]", this.message.prefix()).replace("[AMOUNT]", this.decimalFormat.format(itemStack.getAmount())).replace("[VALUE]", this.decimalFormat.format(result)));
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SELL_PRICE).replace("[ITEM]", itemStack.getType().name().toUpperCase()).replace("[MONEY]", this.decimalFormat.format(this.itemValue.getValue(itemStack.getType()))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)).replace("[PREFIX]", this.message.prefix()).replace("[AMOUNT]", this.decimalFormat.format(itemStack.getAmount())).replace("[VALUE]", this.decimalFormat.format(result)));
        }
    }
}

