/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.math.BigDecimal;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PayCommand
extends CommandManager {
    public PayCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_PAY)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_PAY_USE)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length != 2) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
            return true;
        }
        if (args[0].equals("*")) {
            if (!this.hasPermission(sender, Configs.PERMISSION_PAY_ALL_PLAYERS)) {
                return true;
            }
            if (args[1].equals("*")) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_ALL));
                return true;
            }
            this.payAllPlayers(player, args);
            return true;
        }
        Player target = sender.getServer().getPlayer(args[0]);
        if (target == null) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
            return true;
        }
        if (args[1].equals("*")) {
            this.payAllMoney(player, target);
            return true;
        }
        this.payPlayerMoney(player, target, args);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompletePlayers(sender, args, 1);
    }

    private void payAllPlayers(Player player, String[] args) {
        try {
            BigDecimal money = new BigDecimal(args[1]);
            if (!player.hasPermission(this.config.getString(Configs.PERMISSION_PAY_NEGATIVE)) && -money.doubleValue() >= 0.0) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_NEGATIVE));
                return;
            }
            if (!this.economy.hasEnoughMoney(player.getUniqueId(), money.doubleValue())) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_ENOUGH).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
                return;
            }
            player.getServer().getOnlinePlayers().forEach(all -> {
                this.economy.payMoney(player.getUniqueId(), all.getUniqueId(), money);
                this.sendMessage((CommandSender)all, this.message.getString(Messages.COMMAND_PAY_TARGET).replace("[PLAYER]", player.getName()).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
            });
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_PLAYER).replace("[PLAYER]", "all").replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        }
        catch (NumberFormatException exception) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_NUMBER));
        }
    }

    private void payAllMoney(Player player, Player target) {
        if (!this.hasPermission((CommandSender)player, Configs.PERMISSION_PAY_ALL_MONEY)) {
            return;
        }
        try {
            BigDecimal allMoney = this.economy.getMoney(player.getUniqueId());
            if (!player.hasPermission(this.config.getString(Configs.PERMISSION_PAY_NEGATIVE)) && -allMoney.doubleValue() >= 0.0) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_NEGATIVE));
                return;
            }
            this.economy.payMoney(player.getUniqueId(), target.getUniqueId(), allMoney);
            this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_PAY_TARGET).replace("[PLAYER]", player.getName()).replace("[MONEY]", this.decimalFormat.format(allMoney)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_PLAYER).replace("[PLAYER]", target.getName()).replace("[MONEY]", this.decimalFormat.format(allMoney)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        }
        catch (NumberFormatException exception) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_NUMBER));
        }
    }

    private void payPlayerMoney(Player player, Player target, String[] args) {
        try {
            BigDecimal money = new BigDecimal(args[1]);
            if (!player.hasPermission(this.config.getString(Configs.PERMISSION_PAY_NEGATIVE)) && -money.doubleValue() >= 0.0) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_NEGATIVE));
                return;
            }
            if (!this.economy.hasEnoughMoney(player.getUniqueId(), money.doubleValue())) {
                this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_MONEY_ENOUGH).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
                return;
            }
            this.economy.payMoney(player.getUniqueId(), target.getUniqueId(), money);
            this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_PAY_TARGET).replace("[PLAYER]", player.getName()).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_PAY_PLAYER).replace("[PLAYER]", target.getName()).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        }
        catch (NumberFormatException exception) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.NO_NUMBER));
        }
    }
}

