/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoneyCommand
extends CommandManager {
    public MoneyCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_MONEY_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_MONEY_COMMAND)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length == 0) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_MONEY_USE)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_MONEY_USE)) {
                return true;
            }
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_MONEY_USE).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)).replace("[MONEY]", this.decimalFormat.format(this.economy.getMoney(player.getUniqueId()))));
        } else if (args.length == 1) {
            if (!this.isEnable(sender, Configs.COMMAND_ENABLE_MONEY_OTHER)) {
                return true;
            }
            if (!this.hasPermission(sender, Configs.PERMISSION_MONEY_OTHER)) {
                return true;
            }
            Player target = sender.getServer().getPlayer(args[0]);
            if (target == null) {
                OfflinePlayer offlinePlayer = sender.getServer().getOfflinePlayer(args[0]);
                if (offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore()) {
                    this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_MONEY_OTHER).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)).replace("[MONEY]", this.decimalFormat.format(this.economy.getMoney(offlinePlayer.getUniqueId()))).replace("[PLAYER]", args[0]));
                } else {
                    this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[0]));
                }
                return true;
            }
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_MONEY_OTHER).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)).replace("[MONEY]", this.decimalFormat.format(this.economy.getMoney(target.getUniqueId()))).replace("[PLAYER]", target.getName()));
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return this.tabCompleteOfflinePlayers(sender, args, 1);
    }
}

