/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemValueCommand
extends CommandManager {
    public ItemValueCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ITEM_VALUE_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ITEM_VALUE_COMMAND)) {
            return true;
        }
        if (args.length >= 2) {
            switch (args[0]) {
                case "get": {
                    this.getItemValue(sender, args);
                    break;
                }
                case "set": {
                    this.setItemValue(sender, args);
                    break;
                }
                default: {
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
                    break;
                }
            }
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return this.tabComplete(Arrays.asList("get", "set"), args);
        }
        if (args.length == 2) {
            return this.tabComplete(this.itemValue.getItems(), args);
        }
        return Collections.emptyList();
    }

    private void getItemValue(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ITEM_VALUE_GET)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ITEM_VALUE_GET)) {
            return;
        }
        String materialName = args[1].toUpperCase();
        if (!this.itemValue.existName(materialName)) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_ITEM_VALUE_MATERIAL_NOT_EXIST).replace("[MATERIAL]", materialName));
            return;
        }
        Material material = Material.valueOf((String)materialName);
        if (this.config.getBoolean(Configs.MATERIAL_CASE)) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_ITEM_VALUE_GET).replace("[ITEM]", material.name().toLowerCase()).replace("[MONEY]", this.decimalFormat.format(this.itemValue.getValue(material))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_ITEM_VALUE_GET).replace("[ITEM]", material.name().toUpperCase()).replace("[MONEY]", this.decimalFormat.format(this.itemValue.getValue(material))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        }
    }

    private void setItemValue(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ITEM_VALUE_SET)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ITEM_VALUE_SET)) {
            return;
        }
        String materialName = args[1].toUpperCase();
        if (!this.itemValue.existName(materialName)) {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_ITEM_VALUE_MATERIAL_NOT_EXIST).replace("[MATERIAL]", materialName));
            return;
        }
        Material material = Material.valueOf((String)materialName);
        try {
            BigDecimal price = new BigDecimal(args[2]);
            this.itemValue.setValue(material, price);
            if (this.config.getBoolean(Configs.MATERIAL_CASE)) {
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_ITEM_VALUE_SET).replace("[ITEM]", material.name().toLowerCase()).replace("[MONEY]", this.decimalFormat.format(this.itemValue.getValue(material))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
            } else {
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_ITEM_VALUE_SET).replace("[ITEM]", material.name().toUpperCase()).replace("[MONEY]", this.decimalFormat.format(this.itemValue.getValue(material))).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
            }
        }
        catch (NumberFormatException exception) {
            this.sendMessage(sender, this.message.getString(Messages.NO_NUMBER));
        }
    }
}

