/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands.economy;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EconomyCommand
extends CommandManager {
    public EconomyCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ECONOMY_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ECONOMY_COMMAND)) {
            return true;
        }
        if (args.length >= 2) {
            switch (args[0]) {
                case "set": {
                    this.economySet(sender, args);
                    break;
                }
                case "add": {
                    this.economyAdd(sender, args);
                    break;
                }
                case "remove": {
                    this.economyRemove(sender, args);
                    break;
                }
                case "reset": {
                    this.economyReset(sender, args);
                    break;
                }
                default: {
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
                    break;
                }
            }
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return this.tabComplete(Arrays.asList("set", "add", "remove", "reset"), args);
        }
        if (args.length == 2) {
            return this.tabCompleteOfflinePlayers(sender, args);
        }
        return Collections.emptyList();
    }

    private void economySet(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ECONOMY_SET)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ECONOMY_SET)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            OfflinePlayer offlinePlayer = sender.getServer().getOfflinePlayer(args[1]);
            if (offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore()) {
                try {
                    BigDecimal money = new BigDecimal(args[2]);
                    this.economy.setUsername(offlinePlayer.getUniqueId(), args[1]);
                    this.economy.setMoney(offlinePlayer.getUniqueId(), money);
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_SET).replace("[PLAYER]", args[1]).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
                    this.sendMessage(sender, this.message.getString(Messages.NO_NUMBER));
                }
            } else {
                this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            }
            return;
        }
        try {
            BigDecimal money = new BigDecimal(args[2]);
            this.economy.setMoney(target.getUniqueId(), money);
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_SET).replace("[PLAYER]", target.getName()).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
            this.sendMessage(sender, this.message.getString(Messages.NO_NUMBER));
        }
    }

    private void economyAdd(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ECONOMY_ADD)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ECONOMY_ADD)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            OfflinePlayer offlinePlayer = sender.getServer().getOfflinePlayer(args[1]);
            if (offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore()) {
                try {
                    BigDecimal money = new BigDecimal(args[2]);
                    this.economy.setUsername(offlinePlayer.getUniqueId(), args[1]);
                    this.economy.addMoney(offlinePlayer.getUniqueId(), money);
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_ADD).replace("[PLAYER]", args[1]).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
                    this.sendMessage(sender, this.message.getString(Messages.NO_NUMBER));
                }
            } else {
                this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            }
            return;
        }
        try {
            BigDecimal money = new BigDecimal(args[2]);
            this.economy.addMoney(target.getUniqueId(), money);
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_ADD).replace("[PLAYER]", target.getName()).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
            this.sendMessage(sender, this.message.getString(Messages.NO_NUMBER));
        }
    }

    private void economyRemove(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ECONOMY_REMOVE)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ECONOMY_REMOVE)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            OfflinePlayer offlinePlayer = sender.getServer().getOfflinePlayer(args[1]);
            if (offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore()) {
                try {
                    BigDecimal money = new BigDecimal(args[2]);
                    this.economy.setUsername(offlinePlayer.getUniqueId(), args[1]);
                    this.economy.removeMoney(offlinePlayer.getUniqueId(), money);
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_REMOVE).replace("[PLAYER]", args[1]).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
                    this.sendMessage(sender, this.message.getString(Messages.NO_NUMBER));
                }
            } else {
                this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            }
            return;
        }
        try {
            BigDecimal money = new BigDecimal(args[2]);
            this.economy.removeMoney(target.getUniqueId(), money);
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_REMOVE).replace("[PLAYER]", target.getName()).replace("[MONEY]", this.decimalFormat.format(money)).replace("[CURRENCY]", this.config.getString(Configs.ECONOMY_CURRENCY)));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
            this.sendMessage(sender, this.message.getString(Messages.NO_NUMBER));
        }
    }

    private void economyReset(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_ECONOMY_RESET)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_ECONOMY_RESET)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            OfflinePlayer offlinePlayer = sender.getServer().getOfflinePlayer(args[1]);
            if (offlinePlayer.isOnline() || offlinePlayer.hasPlayedBefore()) {
                this.economy.setUsername(offlinePlayer.getUniqueId(), args[1]);
                this.economy.resetMoney(offlinePlayer.getUniqueId());
                this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_RESET).replace("[PLAYER]", args[1]));
            } else {
                this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            }
            return;
        }
        this.economy.resetMoney(target.getUniqueId());
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_ECONOMY_RESET).replace("[PLAYER]", target.getName()));
    }
}

