/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnSignCommand
extends CommandManager {
    public UnSignCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_UN_SIGN)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_UN_SIGN)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (player.getItemInHand().getType().equals((Object)Material.AIR)) {
            return true;
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_NOT_COOLDOWN))) {
            this.createItem(player.getItemInHand());
            return true;
        }
        if (this.cooldown.getDuration(player.getUniqueId(), "UnSign") <= System.currentTimeMillis()) {
            this.cooldown.removeCooldown(player.getUniqueId(), "UnSign");
        }
        if (this.cooldown.hasCooldown(player.getUniqueId(), "UnSign")) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COOLDOWN_MESSAGE).replace("[DATE]", this.cooldown.getExpired(player.getUniqueId(), "UnSign").replace(" ", this.message.getString(Messages.COOLDOWN_DATE))));
            return true;
        }
        this.cooldown.addCooldown(player.getUniqueId(), "Sign", this.config.getLong(Configs.TIME_UN_SIGN_COOLDOWN));
        this.createItem(player.getItemInHand());
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }

    private ItemStack createItem(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(new ArrayList());
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

