/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.HexColor;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignCommand
extends CommandManager {
    public SignCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_SIGN)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_SIGN)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (String arg : args) {
            messageBuilder.append(arg).append(" ");
        }
        String messages = messageBuilder.toString();
        messages = messages.trim();
        if (player.getItemInHand().getType().equals((Object)Material.AIR)) {
            return true;
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_NOT_COOLDOWN))) {
            this.createItem(player, messages);
            return true;
        }
        if (this.cooldown.getDuration(player.getUniqueId(), "Sign") <= System.currentTimeMillis()) {
            this.cooldown.removeCooldown(player.getUniqueId(), "Sign");
        }
        if (this.cooldown.hasCooldown(player.getUniqueId(), "Sign")) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COOLDOWN_MESSAGE).replace("[DATE]", this.cooldown.getExpired(player.getUniqueId(), "Sign").replace(" ", this.message.getString(Messages.COOLDOWN_DATE))));
            return true;
        }
        this.cooldown.addCooldown(player.getUniqueId(), "Sign", this.config.getLong(Configs.TIME_SIGN_COOLDOWN));
        this.createItem(player, messages);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }

    private void createItem(Player player, String lore) {
        ItemStack itemStack = player.getItemInHand();
        ItemMeta itemMeta = itemStack.getItemMeta();
        SimpleDateFormat format = new SimpleDateFormat(this.config.getString(Configs.PATTERN_COMMAND_SIGN));
        String created = format.format(new Date());
        ArrayList<String> loreList = new ArrayList<String>(Arrays.asList(HexColor.format(lore), "\n"));
        loreList.add(HexColor.format(this.message.getString(Messages.COMMAND_SIGN_CREATE).replace("[NAME]", player.getName()).replace("[DATE]", created.replace(" ", this.message.getString(Messages.COMMAND_SIGN_DATE)))));
        itemMeta.setLore(loreList);
        itemStack.setItemMeta(itemMeta);
    }
}

