/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadCommand
extends CommandManager {
    public HeadCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_HEAD)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_HEAD)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (args.length == 0) {
            this.setFunction(player, player.getName());
        } else if (args.length == 1) {
            this.setFunction(player, args[0]);
        } else {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }

    private void setFunction(Player player, String name) {
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_NOT_COOLDOWN))) {
            player.getInventory().addItem(new ItemStack[]{this.addHead(name)});
            return;
        }
        if (this.cooldown.getDuration(player.getUniqueId(), "Head") <= System.currentTimeMillis()) {
            this.cooldown.removeCooldown(player.getUniqueId(), "Head");
        }
        if (this.cooldown.hasCooldown(player.getUniqueId(), "Head")) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COOLDOWN_MESSAGE).replace("[DATE]", this.cooldown.getExpired(player.getUniqueId(), "Head").replace(" ", this.message.getString(Messages.COOLDOWN_DATE))));
            return;
        }
        this.cooldown.addCooldown(player.getUniqueId(), "Head", this.config.getLong(Configs.TIME_HEAD_COOLDOWN));
        player.getInventory().addItem(new ItemStack[]{this.addHead(name)});
    }

    private ItemStack addHead(String name) {
        ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        skullMeta.setOwner(name);
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }
}

