/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameModeCommand
extends CommandManager {
    public GameModeCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_COMMAND)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_COMMAND)) {
            return true;
        }
        if (args.length == 1) {
            switch (args[0]) {
                case "survival": {
                    this.gameModeUseSurvival(sender);
                    break;
                }
                case "creative": {
                    this.gameModeUseCreative(sender);
                    break;
                }
                case "adventure": {
                    this.gameModeUseAdventure(sender);
                    break;
                }
                case "spectator": {
                    this.gameModeUseSpectator(sender);
                    break;
                }
                case "0": {
                    this.gameModeUseSurvival(sender);
                    break;
                }
                case "1": {
                    this.gameModeUseCreative(sender);
                    break;
                }
                case "2": {
                    this.gameModeUseAdventure(sender);
                    break;
                }
                case "3": {
                    this.gameModeUseSpectator(sender);
                    break;
                }
                default: {
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
                    break;
                }
            }
        } else if (args.length == 2) {
            switch (args[0]) {
                case "survival": {
                    this.gameModeOtherSurvival(sender, args);
                    break;
                }
                case "creative": {
                    this.gameModeOtherCreative(sender, args);
                    break;
                }
                case "adventure": {
                    this.gameModeOtherAdventure(sender, args);
                    break;
                }
                case "spectator": {
                    this.gameModeOtherSpectator(sender, args);
                    break;
                }
                case "0": {
                    this.gameModeOtherSurvival(sender, args);
                    break;
                }
                case "1": {
                    this.gameModeOtherCreative(sender, args);
                    break;
                }
                case "2": {
                    this.gameModeOtherAdventure(sender, args);
                    break;
                }
                case "3": {
                    this.gameModeOtherSpectator(sender, args);
                    break;
                }
                default: {
                    this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
                    break;
                }
            }
        } else {
            this.sendMessage(sender, this.message.getString(Messages.COMMAND_SYNTAX).replace("[USAGE]", command.getUsage()));
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return this.tabComplete(Arrays.asList("survival", "creative", "adventure", "spectator", "0", "1", "2", "3"), args);
        }
        if (args.length == 2) {
            return this.tabCompletePlayers(sender, args);
        }
        return Collections.emptyList();
    }

    private void gameModeUseSurvival(CommandSender sender) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_USE_SURVIVAL)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_USE_SURVIVAL)) {
            return;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return;
        }
        player.setGameMode(GameMode.SURVIVAL);
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.SURVIVAL.name().toLowerCase()));
    }

    private void gameModeUseCreative(CommandSender sender) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_USE_CREATIVE)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_USE_CREATIVE)) {
            return;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return;
        }
        player.setGameMode(GameMode.CREATIVE);
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.CREATIVE.name().toLowerCase()));
    }

    private void gameModeUseAdventure(CommandSender sender) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_USE_ADVENTURE)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_USE_ADVENTURE)) {
            return;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return;
        }
        player.setGameMode(GameMode.ADVENTURE);
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.ADVENTURE.name().toLowerCase()));
    }

    private void gameModeUseSpectator(CommandSender sender) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_USE_SPECTATOR)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_USE_SPECTATOR)) {
            return;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return;
        }
        player.setGameMode(GameMode.SPECTATOR);
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.SPECTATOR.name().toLowerCase()));
    }

    private void gameModeOtherSurvival(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_OTHER_SURVIVAL)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_OTHER_SURVIVAL)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            return;
        }
        target.setGameMode(GameMode.SURVIVAL);
        this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.SURVIVAL.name()).toLowerCase());
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_GAME_MODE_OTHER).replace("[MODE]", GameMode.SURVIVAL.name().toLowerCase()).replace("[PLAYER]", target.getName()));
    }

    private void gameModeOtherCreative(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_OTHER_CREATIVE)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_OTHER_CREATIVE)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            return;
        }
        target.setGameMode(GameMode.CREATIVE);
        this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.CREATIVE.name().toLowerCase()));
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_GAME_MODE_OTHER).replace("[MODE]", GameMode.CREATIVE.name().toLowerCase()).replace("[PLAYER]", target.getName()));
    }

    private void gameModeOtherAdventure(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_OTHER_ADVENTURE)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_OTHER_ADVENTURE)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            return;
        }
        target.setGameMode(GameMode.ADVENTURE);
        this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.ADVENTURE.name().toLowerCase()));
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_GAME_MODE_OTHER).replace("[MODE]", GameMode.ADVENTURE.name().toLowerCase()).replace("[PLAYER]", target.getName()));
    }

    private void gameModeOtherSpectator(CommandSender sender, String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_GAME_MODE_OTHER_SPECTATOR)) {
            return;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_GAME_MODE_OTHER_SPECTATOR)) {
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null) {
            this.sendMessage(sender, this.message.getString(Messages.NO_PLAYER_EXIST).replace("[PLAYER]", args[1]));
            return;
        }
        target.setGameMode(GameMode.SPECTATOR);
        this.sendMessage((CommandSender)target, this.message.getString(Messages.COMMAND_GAME_MODE_USE).replace("[MODE]", GameMode.SPECTATOR.name().toLowerCase()));
        this.sendMessage(sender, this.message.getString(Messages.COMMAND_GAME_MODE_OTHER).replace("[MODE]", GameMode.SPECTATOR.name().toLowerCase()).replace("[PLAYER]", target.getName()));
    }
}

