/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.command.commands;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.command.CommandManager;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DayCommand
extends CommandManager {
    public DayCommand(Main main) {
        super(main);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!this.isEnable(sender, Configs.COMMAND_ENABLE_TIME_DAY)) {
            return true;
        }
        if (!this.hasPermission(sender, Configs.PERMISSION_TIME_DAY)) {
            return true;
        }
        Player player = this.getPlayer(sender);
        if (!this.existPlayer(sender)) {
            return true;
        }
        if (player.hasPermission(this.config.getString(Configs.PERMISSION_NOT_COOLDOWN))) {
            player.getWorld().setTime(this.config.getLong(Configs.TIME_DAY_TIME));
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_DAY));
            return true;
        }
        if (this.cooldown.getDuration(player.getUniqueId(), "Day") <= System.currentTimeMillis()) {
            this.cooldown.removeCooldown(player.getUniqueId(), "Day");
        }
        if (this.cooldown.hasCooldown(player.getUniqueId(), "Day")) {
            this.sendMessage((CommandSender)player, this.message.getString(Messages.COOLDOWN_MESSAGE).replace("[DATE]", this.cooldown.getExpired(player.getUniqueId(), "Day").replace(" ", this.message.getString(Messages.COOLDOWN_DATE))));
            return true;
        }
        this.cooldown.addCooldown(player.getUniqueId(), "Day", this.config.getLong(Configs.TIME_DAY_COOLDOWN));
        player.getWorld().setTime(this.config.getLong(Configs.TIME_DAY_TIME));
        this.sendMessage((CommandSender)player, this.message.getString(Messages.COMMAND_DAY));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }
}

