/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public abstract class PlayerInventoryLoader {
    public YamlConfiguration config;
    public List<Integer> itemID;
    public List<String> enchantment;
    public List<String> lore;
    private Inventory inventory;

    public abstract void create(UUID var1);

    public abstract void save();

    public Inventory loadInventory(Player player, int slot) {
        this.create(player.getUniqueId());
        String path = "Inventory." + slot;
        this.itemID = this.getItemID(slot);
        Inventory inventory = player.getServer().createInventory(null, this.getInt(path + ".Size"), this.getString(path + ".Name"));
        for (int i : this.itemID) {
            Material material = Material.matchMaterial((String)this.getString(path + "." + i + ".Name"));
            if (material == null) continue;
            String displayName = this.getString(path + "." + i + ".DisplayName");
            int amount = this.getInt(path + "." + i + ".Amount");
            this.enchantment = this.getEnchantment(slot, i);
            this.lore = this.getLore(slot, i);
            ItemStack itemStack = new ItemStack(material, amount);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(displayName);
            for (String name : this.enchantment) {
                int enchantLevel = this.getInt(path + "." + i + ".Enchantments." + name + ".Level");
                itemMeta.addEnchant(Enchantment.getByName((String)name), enchantLevel, true);
            }
            itemMeta.setLore(this.lore);
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(i, itemStack);
        }
        return inventory;
    }

    public Inventory loadInventory(Player player, int slot, String title, int size) {
        this.create(player.getUniqueId());
        String path = "Inventory." + slot;
        String contents = this.getString(path + ".Contents");
        String storageContents = this.getString(path + ".StorageContents");
        Inventory inventory = player.getServer().createInventory(null, size, title);
        if (contents != null) {
            inventory.setContents(this.loadItemStackArray(contents));
        }
        if (storageContents != null) {
            inventory.setStorageContents(this.loadItemStackArray(storageContents));
        }
        return inventory;
    }

    public Inventory loadInventory(UUID uuid, Server server, int slot, String title, int size) {
        this.create(uuid);
        String path = "Inventory." + slot;
        String contents = this.getString(path + ".Contents");
        String storageContents = this.getString(path + ".StorageContents");
        Inventory inventory = server.createInventory(null, size, title);
        if (contents != null) {
            inventory.setContents(this.loadItemStackArray(contents));
        }
        if (storageContents != null) {
            inventory.setStorageContents(this.loadItemStackArray(storageContents));
        }
        return inventory;
    }

    public void saveInventory(UUID uuid, Inventory inventory, int slot) {
        this.create(uuid);
        String path = "Inventory." + slot;
        this.itemID = this.getItemID(slot);
        this.set(path + ".Name", inventory.getType().name());
        this.set(path + ".Size", inventory.getSize());
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack == null) continue;
            this.enchantment = this.getEnchantment(slot, i);
            this.lore = this.getLore(slot, i);
            this.set(path + "." + i + ".Name", itemStack.getType().name());
            this.set(path + "." + i + ".DisplayName", itemStack.getItemMeta().getDisplayName());
            this.set(path + "." + i + ".Amount", itemStack.getAmount());
            for (Map.Entry entry : itemStack.getItemMeta().getEnchants().entrySet()) {
                String enchantName = ((Enchantment)entry.getKey()).getName();
                if (!this.enchantment.contains(enchantName)) {
                    this.enchantment.add(enchantName);
                }
                this.set(path + "." + i + ".Enchantments." + enchantName + ".Level", entry.getValue());
            }
            this.set(path + "." + i + ".Enchantments.ListName", this.enchantment);
            for (String s : Objects.requireNonNull(itemStack.getItemMeta().getLore())) {
                if (this.lore.contains(s)) continue;
                this.lore.add(s);
            }
            this.set(path + "." + i + ".Lore", this.lore);
            if (this.itemID.contains(i)) continue;
            this.itemID.add(i);
        }
        this.set(path + ".ListIDs", this.itemID.stream().sorted().collect(Collectors.toList()));
        this.save();
    }

    public void saveInventory(UUID uuid, Inventory inventory, int slot, String title) {
        this.create(uuid);
        String path = "Inventory." + slot;
        String contents = this.saveItemStackArray(inventory.getContents());
        String storageContents = this.saveItemStackArray(inventory.getStorageContents());
        this.set(path + ".Title", title);
        this.set(path + ".Size", inventory.getSize());
        this.set(path + ".Contents", contents);
        this.set(path + ".StorageContents", storageContents);
        this.save();
    }

    public void saveInventory(UUID uuid, Inventory inventory, int slot, String title, boolean access) {
        this.create(uuid);
        String path = "Inventory." + slot;
        String contents = this.saveItemStackArray(inventory.getContents());
        String storageContents = this.saveItemStackArray(inventory.getStorageContents());
        this.set(path + ".Title", title);
        this.set(path + ".Size", inventory.getSize());
        this.set(path + ".Access", access);
        this.set(path + ".Contents", contents);
        this.set(path + ".StorageContents", storageContents);
        this.save();
    }

    public List<Integer> getItemID(int slot) {
        this.itemID = new LinkedList<Integer>();
        String path = "Inventory." + slot + ".ListIDs";
        if (this.config.contains(path)) {
            this.itemID = this.config.getIntegerList(path);
        }
        return this.itemID;
    }

    public List<String> getEnchantment(int slot, int itemID) {
        this.enchantment = new ArrayList<String>();
        String path = "Inventory." + slot + "." + itemID + ".Enchantments.ListName";
        if (this.config.contains(path)) {
            this.enchantment = this.config.getStringList(path);
        }
        return this.enchantment;
    }

    public List<String> getLore(int slot, int itemID) {
        this.lore = new LinkedList<String>();
        String path = "Inventory." + slot + "." + itemID + ".Lore";
        if (this.config.contains(path)) {
            this.lore = this.config.getStringList(path);
        }
        return this.lore;
    }

    public ItemStack[] loadItemStackArray(String data) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return items;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Unable to decode class type.", e);
        }
    }

    public String saveItemStackArray(ItemStack[] items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(items.length);
            for (ItemStack item : items) {
                dataOutput.writeObject((Object)item);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save item stacks.", e);
        }
    }

    public String getInventorySize(UUID uuid, int slot) {
        this.create(uuid);
        return this.getString("Inventory." + slot + ".Size");
    }

    public boolean hasAccess(UUID uuid, int slot) {
        this.create(uuid);
        return this.getBoolean("Inventory." + slot + ".Access");
    }

    public void setAccess(UUID uuid, int slot, boolean access) {
        this.create(uuid);
        this.set("Inventory." + slot + ".Access", access);
        this.save();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }
}

