/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.api.Economy;
import de.murmelmeister.citybuild.configs.Config;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.HexColor;
import de.murmelmeister.citybuild.util.config.Configs;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.slf4j.Logger;

public class ItemValue {
    private final Logger logger;
    private final Config defaultConfig;
    private final Economy economy;
    private File file;
    private YamlConfiguration config;
    private List<String> items;

    public ItemValue(Main main) {
        this.logger = main.getLogger();
        this.defaultConfig = main.getConfig();
        this.economy = main.getEconomy();
    }

    public void register() {
        this.create();
        this.load();
        this.save();
    }

    public void create() {
        String fileName = "itemValue.yml";
        this.file = FileUtil.createFile(this.logger, String.format("plugins//%s//Economy//", this.defaultConfig.getString(Configs.FILE_NAME)), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void load() {
        for (Material material : Material.values()) {
            if (this.get(material.name() + ".Value") == null) {
                this.setValue(material, this.defaultSellPrice());
            }
            if (this.get(material.name() + ".ID") != null) continue;
            this.set(material.name() + ".ID", UUID.randomUUID().toString());
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BigDecimal sellItem(Player player, ItemStack itemStack) {
        int amount = itemStack.getAmount();
        BigDecimal price = BigDecimal.valueOf(this.getValue(itemStack.getType()));
        if (amount <= 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = price.multiply(BigDecimal.valueOf(amount));
        ItemStack item = itemStack.clone();
        item.setAmount(amount);
        if (!player.getInventory().containsAtLeast(item, amount)) {
            player.sendMessage(" Trying to remove more items than are available.");
        }
        player.getInventory().removeItem(new ItemStack[]{item});
        player.updateInventory();
        this.economy.addMoney(player.getUniqueId(), result);
        return result;
    }

    public BigDecimal defaultSellPrice() {
        return BigDecimal.valueOf(this.defaultConfig.getDouble(Configs.ECONOMY_DEFAULT_ITEM_SELL_PRICE));
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    private Object get(String path) {
        return this.config.get(path);
    }

    public double getValue(Material material) {
        return this.config.getDouble(material.name() + ".Value");
    }

    public String getID(Material material) {
        return this.config.getString(material.name() + ".ID");
    }

    public void setValue(Material material, BigDecimal price) {
        this.items = this.getItems();
        if (!this.items.contains(material.name())) {
            this.items.add(material.name());
            this.set("ItemList", this.items);
        }
        this.set(material.name() + ".Value", price);
    }

    public ItemStack createItem(Material material) {
        ItemStack itemStack = new ItemStack(material);
        itemStack.setItemMeta(this.createItemMeta(itemStack));
        return itemStack;
    }

    public ItemMeta createItemMeta(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(HexColor.format("#222222ID: " + this.getID(itemStack.getType())));
        itemMeta.setLore(lore);
        return itemMeta;
    }

    public boolean existName(String name) {
        return this.config.getString(name) != null;
    }

    public List<String> getItems() {
        this.items = new ArrayList<String>();
        if (this.config.contains("ItemList")) {
            this.items = this.config.getStringList("ItemList");
        }
        return this.items;
    }
}

