/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.configs.Config;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.slf4j.Logger;

public class Homes {
    private final Logger logger;
    private final Config defaultConfig;
    private final Server server;
    private File file;
    private YamlConfiguration config;
    private List<String> homeList;

    public Homes(Main main) {
        this.logger = main.getLogger();
        this.defaultConfig = main.getConfig();
        this.server = main.getInstance().getServer();
    }

    public void create(UUID uuid) {
        String fileName = String.valueOf(uuid) + ".yml";
        this.file = FileUtil.createFile(this.logger, String.format("plugins//%s//Homes//", this.defaultConfig.getString(Configs.FILE_NAME)), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createUsername(UUID uuid, String name) {
        this.create(uuid);
        this.set("Username", name);
        this.homeList = this.getHomeList();
        this.set("HomeList", this.homeList);
        this.save();
    }

    public void addHome(Player player, String name) {
        Location location = player.getLocation();
        String path = "Homes." + name;
        String worldName = location.getWorld().getName();
        String environment = location.getWorld().getEnvironment().name();
        double x = (double)location.getBlockX() + 0.5;
        double y = (double)location.getBlockY() + 0.25;
        double z = (double)location.getBlockZ() + 0.5;
        double yaw = Math.round(location.getYaw() / 45.0f) * 45;
        double pitch = Math.round(location.getPitch() / 45.0f) * 45;
        this.create(player.getUniqueId());
        this.homeList = this.getHomeList();
        if (!this.homeList.contains(name)) {
            this.homeList.add(name);
            this.set("HomeList", this.homeList);
        }
        this.set(path + ".Name", name);
        this.set(path + ".WorldName", worldName);
        this.set(path + ".Environment", environment);
        this.set(path + ".X", x);
        this.set(path + ".Y", y);
        this.set(path + ".Z", z);
        this.set(path + ".Yaw", yaw);
        this.set(path + ".Pitch", pitch);
        this.save();
    }

    public void addHome(UUID target, Player player, String name) {
        Location location = player.getLocation();
        String path = "Homes." + name;
        String worldName = location.getWorld().getName();
        String environment = location.getWorld().getEnvironment().name();
        double x = (double)location.getBlockX() + 0.5;
        double y = (double)location.getBlockY() + 0.25;
        double z = (double)location.getBlockZ() + 0.5;
        double yaw = Math.round(location.getYaw() / 45.0f) * 45;
        double pitch = Math.round(location.getPitch() / 45.0f) * 45;
        this.create(target);
        this.homeList = this.getHomeList();
        if (!this.homeList.contains(name)) {
            this.homeList.add(name);
            this.set("HomeList", this.homeList);
        }
        this.set(path + ".Name", name);
        this.set(path + ".WorldName", worldName);
        this.set(path + ".Environment", environment);
        this.set(path + ".X", x);
        this.set(path + ".Y", y);
        this.set(path + ".Z", z);
        this.set(path + ".Yaw", yaw);
        this.set(path + ".Pitch", pitch);
        this.save();
    }

    public void removeHome(UUID uuid, String name) {
        this.create(uuid);
        this.homeList = this.getHomeList();
        this.homeList.remove(name);
        this.set("HomeList", this.homeList);
        this.set("Homes." + name, null);
        this.save();
    }

    public Location getHome(UUID uuid, String name) {
        this.create(uuid);
        String path = "Homes." + name;
        String worldName = this.getString(path + ".WorldName");
        double x = this.getDouble(path + ".X");
        double y = this.getDouble(path + ".Y");
        double z = this.getDouble(path + ".Z");
        double yaw = this.getDouble(path + ".Yaw");
        double pitch = this.getDouble(path + ".Pitch");
        World world = this.server.getWorld(worldName);
        return new Location(world, x, y, z, (float)yaw, (float)pitch);
    }

    public boolean hasHome(UUID uuid, String name) {
        this.create(uuid);
        return this.config.get("Homes." + name) != null;
    }

    public List<String> getHomeList() {
        this.homeList = new ArrayList<String>();
        if (this.config.contains("HomeList")) {
            this.homeList = this.config.getStringList("HomeList");
        }
        return this.homeList;
    }

    private void set(String path, Object value) {
        this.config.set(path, value);
    }

    private String getString(String path) {
        return this.config.getString(path);
    }

    private double getDouble(String path) {
        return this.config.getDouble(path);
    }
}

