/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.api.PlayerInventoryLoader;
import de.murmelmeister.citybuild.configs.Config;
import de.murmelmeister.citybuild.configs.Message;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.HexColor;
import de.murmelmeister.citybuild.util.config.Configs;
import de.murmelmeister.citybuild.util.config.Messages;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.slf4j.Logger;

public class EnderChest
extends PlayerInventoryLoader {
    private final Logger logger;
    private final Config defaultConfig;
    private final Message message;
    private Player target;
    private OfflinePlayer offlineTarget;
    private List<UUID> uuids;
    private File file;

    public EnderChest(Main main) {
        this.logger = main.getLogger();
        this.defaultConfig = main.getConfig();
        this.message = main.getMessage();
    }

    @Override
    public void create(UUID uuid) {
        String fileName = String.valueOf(uuid) + ".yml";
        this.file = FileUtil.createFile(this.logger, String.format("plugins//%s//EnderChest//UserData//", this.defaultConfig.getString(Configs.FILE_NAME)), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    @Override
    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createEnderChestGUI(Player player) {
        Inventory inventory = player.getServer().createInventory(null, 9, HexColor.format(this.message.getString(Messages.ENDER_CHEST_MENU_USE)));
        for (int i = 1; i < 10; ++i) {
            if (player.hasPermission(this.defaultConfig.getString(Configs.PERMISSION_ENDER_CHEST_SLOTS) + "." + i)) {
                inventory.setItem(i - 1, this.createItem(Material.matchMaterial((String)this.defaultConfig.getString(Configs.ENDER_CHEST_MATERIAL_UNLOCKED)), HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_UNLOCKED).replace("[SLOT]", "" + i))));
                continue;
            }
            inventory.setItem(i - 1, this.createItem(Material.matchMaterial((String)this.defaultConfig.getString(Configs.ENDER_CHEST_MATERIAL_LOCKED)), HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_LOCKED))));
        }
        player.openInventory(inventory);
    }

    public void createEnderChestGUI(Player player, Player target) {
        this.setTarget(target);
        Inventory inventory = player.getServer().createInventory(null, 9, HexColor.format(this.message.getString(Messages.ENDER_CHEST_MENU_OTHER).replace("[PLAYER]", target.getName())));
        for (int i = 1; i < 10; ++i) {
            if (target.hasPermission(this.defaultConfig.getString(Configs.PERMISSION_ENDER_CHEST_SLOTS) + "." + i)) {
                inventory.setItem(i - 1, this.createItem(Material.matchMaterial((String)this.defaultConfig.getString(Configs.ENDER_CHEST_MATERIAL_UNLOCKED)), HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_UNLOCKED).replace("[SLOT]", "" + i))));
                continue;
            }
            inventory.setItem(i - 1, this.createItem(Material.matchMaterial((String)this.defaultConfig.getString(Configs.ENDER_CHEST_MATERIAL_LOCKED)), HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_LOCKED))));
        }
        player.openInventory(inventory);
    }

    public void createEnderChestGUI(Player player, OfflinePlayer target) {
        this.setOfflineTarget(target);
        Inventory inventory = player.getServer().createInventory(null, 9, HexColor.format(this.message.getString(Messages.ENDER_CHEST_MENU_OTHER).replace("[PLAYER]", target.getName())));
        for (int i = 1; i < 10; ++i) {
            if (this.hasAccess(target.getUniqueId(), i)) {
                inventory.setItem(i - 1, this.createItem(Material.matchMaterial((String)this.defaultConfig.getString(Configs.ENDER_CHEST_MATERIAL_UNLOCKED)), HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_UNLOCKED).replace("[SLOT]", "" + i))));
                continue;
            }
            inventory.setItem(i - 1, this.createItem(Material.matchMaterial((String)this.defaultConfig.getString(Configs.ENDER_CHEST_MATERIAL_LOCKED)), HexColor.format(this.message.getString(Messages.ENDER_CHEST_MATERIAL_LOCKED))));
        }
        player.openInventory(inventory);
    }

    private ItemStack createItem(Material material, String displayName) {
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(displayName);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public Player getTarget() {
        return this.target;
    }

    public void setTarget(Player target) {
        this.target = target;
    }

    public OfflinePlayer getOfflineTarget() {
        return this.offlineTarget;
    }

    public void setOfflineTarget(OfflinePlayer offlineTarget) {
        this.offlineTarget = offlineTarget;
    }
}

