/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.configs.Config;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Economy {
    private final Logger logger;
    private final Config defaultConfig;
    private File file;
    private YamlConfiguration config;

    public Economy(Main main) {
        this.logger = main.getLogger();
        this.defaultConfig = main.getConfig();
    }

    public void create(UUID uuid) {
        String fileName = String.valueOf(uuid) + ".yml";
        this.file = FileUtil.createFile(this.logger, String.format("plugins//%s//Economy//UserData//", this.defaultConfig.getString(Configs.FILE_NAME)), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUsername(UUID uuid, String name) {
        this.create(uuid);
        this.set("Username", name);
        this.save();
    }

    public void createAccount(UUID uuid) {
        this.create(uuid);
        if (this.config.getString("Money") == null) {
            this.set("Money", this.defaultMoney());
        }
        this.save();
    }

    public BigDecimal getMoney(UUID uuid) {
        this.create(uuid);
        BigDecimal exactMoney = this.defaultMoney();
        double money = exactMoney.doubleValue();
        new BigDecimal(money);
        money = this.config.getDouble("Money");
        exactMoney = BigDecimal.valueOf(money);
        return exactMoney;
    }

    public void setMoney(UUID uuid, BigDecimal money) {
        this.create(uuid);
        this.set("Money", money);
        this.save();
    }

    public void addMoney(UUID uuid, BigDecimal money) {
        this.create(uuid);
        BigDecimal amount = this.getMoney(uuid).add(money, MathContext.DECIMAL128);
        this.set("Money", amount);
        this.save();
    }

    public void removeMoney(UUID uuid, BigDecimal money) {
        this.create(uuid);
        BigDecimal amount = this.getMoney(uuid).subtract(money, MathContext.DECIMAL128);
        this.set("Money", amount);
        this.save();
    }

    public void resetMoney(UUID uuid) {
        this.create(uuid);
        this.set("Money", this.defaultMoney());
        this.save();
    }

    public void payMoney(UUID player, UUID target, BigDecimal money) {
        this.removeMoney(player, money);
        this.addMoney(target, money);
    }

    public boolean hasEnoughMoney(UUID uuid, double money) {
        this.create(uuid);
        return money <= this.getMoney(uuid).doubleValue();
    }

    public BigDecimal defaultMoney() {
        return BigDecimal.valueOf(this.defaultConfig.getDouble(Configs.ECONOMY_DEFAULT_MONEY));
    }

    private void set(String path, Object value) {
        this.config.set(path, value);
    }
}

