/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild.api;

import de.murmelmeister.citybuild.Main;
import de.murmelmeister.citybuild.configs.Config;
import de.murmelmeister.citybuild.util.FileUtil;
import de.murmelmeister.citybuild.util.config.Configs;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Cooldown {
    private final Logger logger;
    private final Config defaultConfig;
    private File file;
    private YamlConfiguration config;

    public Cooldown(Main main) {
        this.logger = main.getLogger();
        this.defaultConfig = main.getConfig();
    }

    public void create(UUID uuid) {
        String fileName = String.valueOf(uuid) + ".yml";
        this.file = FileUtil.createFile(this.logger, String.format("plugins//%s//Cooldown//", this.defaultConfig.getString(Configs.FILE_NAME)), fileName);
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void setUsername(UUID uuid, String name) {
        this.create(uuid);
        this.set("Username", name);
        this.save();
    }

    public void addCooldown(UUID uuid, String cooldownName, long time) {
        this.create(uuid);
        long duration = time + System.currentTimeMillis();
        SimpleDateFormat format = new SimpleDateFormat(this.defaultConfig.getString(Configs.PATTERN_CONFIG));
        String created = format.format(new Date());
        String expired = format.format(duration);
        String path = "Cooldown." + cooldownName;
        this.set(path + ".Name", cooldownName);
        this.set(path + ".Duration", duration);
        this.set(path + ".Created", created);
        this.set(path + ".Expired", expired);
        this.save();
    }

    public void removeCooldown(UUID uuid, String cooldownName) {
        this.create(uuid);
        this.set("Cooldown." + cooldownName, null);
        this.save();
    }

    public boolean hasCooldown(UUID uuid, String cooldownName) {
        this.create(uuid);
        return this.config.get("Cooldown." + cooldownName) != null;
    }

    public long getDuration(UUID uuid, String cooldownName) {
        this.create(uuid);
        return this.config.getLong("Cooldown." + cooldownName + ".Duration");
    }

    public String getExpired(UUID uuid, String cooldownName) {
        this.create(uuid);
        return this.config.getString("Cooldown." + cooldownName + ".Expired");
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void set(String path, Object value) {
        this.config.set(path, value);
    }
}

