/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.citybuild;

import de.murmelmeister.citybuild.CityBuild;
import de.murmelmeister.citybuild.api.Cooldown;
import de.murmelmeister.citybuild.api.Economy;
import de.murmelmeister.citybuild.api.EnderChest;
import de.murmelmeister.citybuild.api.Homes;
import de.murmelmeister.citybuild.api.ItemValue;
import de.murmelmeister.citybuild.api.Locations;
import de.murmelmeister.citybuild.command.Commands;
import de.murmelmeister.citybuild.configs.Config;
import de.murmelmeister.citybuild.configs.Message;
import de.murmelmeister.citybuild.listener.Listeners;
import de.murmelmeister.citybuild.util.ListUtil;
import de.murmelmeister.citybuild.util.TablistUtil;
import de.murmelmeister.citybuild.util.scoreboard.TestScoreboard;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.slf4j.Logger;

public class Main {
    private final CityBuild instance;
    private final Logger logger;
    private final ListUtil listUtil;
    private final Config config;
    private final Message message;
    private final Cooldown cooldown;
    private final Locations locations;
    private final Homes homes;
    private final Economy economy;
    private final ItemValue itemValue;
    private final EnderChest enderChest;
    private final Listeners listeners;
    private final Commands commands;
    private BukkitTask scoreboardTask;
    private BukkitTask tablistTask;
    private final Map<Player, TestScoreboard> playerTestScoreboard = new ConcurrentHashMap<Player, TestScoreboard>();
    private final Map<Player, TablistUtil> playerTablistUtil = new ConcurrentHashMap<Player, TablistUtil>();

    public Main(CityBuild instance) {
        this.instance = instance;
        this.logger = instance.getSLF4JLogger();
        this.listUtil = new ListUtil();
        this.config = new Config(this);
        this.message = new Message(this);
        this.cooldown = new Cooldown(this);
        this.locations = new Locations(this);
        this.homes = new Homes(this);
        this.economy = new Economy(this);
        this.itemValue = new ItemValue(this);
        this.enderChest = new EnderChest(this);
        this.listeners = new Listeners(this);
        this.commands = new Commands(this);
    }

    public void disable() {
        this.instance.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.instance);
        if (this.scoreboardTask != null && !this.scoreboardTask.isCancelled()) {
            this.scoreboardTask.cancel();
        }
        if (this.tablistTask != null && !this.tablistTask.isCancelled()) {
            this.tablistTask.cancel();
        }
        this.playerTestScoreboard.clear();
        this.playerTablistUtil.clear();
    }

    public void enable() {
        this.config.register();
        this.message.register();
        this.locations.create();
        this.itemValue.register();
        this.listeners.register();
        this.commands.register();
        this.instance.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.instance, "BungeeCord");
        this.scoreboardTask = this.instance.getServer().getScheduler().runTaskTimer((Plugin)this.instance, () -> {
            for (Player player : this.instance.getServer().getOnlinePlayers()) {
                this.playerTestScoreboard.computeIfAbsent(player, user -> new TestScoreboard((Player)user, this)).run();
            }
        }, 0L, 1L);
        this.tablistTask = this.instance.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.instance, () -> {
            for (Player player : this.instance.getServer().getOnlinePlayers()) {
                this.playerTablistUtil.computeIfAbsent(player, user -> new TablistUtil(player, this)).setScoreboardTabList();
            }
        }, 0L, 1L);
    }

    public CityBuild getInstance() {
        return this.instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ListUtil getListUtil() {
        return this.listUtil;
    }

    public Config getConfig() {
        return this.config;
    }

    public Message getMessage() {
        return this.message;
    }

    public Cooldown getCooldown() {
        return this.cooldown;
    }

    public Locations getLocations() {
        return this.locations;
    }

    public Homes getHomes() {
        return this.homes;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public ItemValue getItemValue() {
        return this.itemValue;
    }

    public EnderChest getEnderChest() {
        return this.enderChest;
    }
}

