/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.playtime;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.playtime.UserPlayTime;
import de.murmelmeister.murmelapi.user.playtime.UserPlayTimeCache;
import de.murmelmeister.murmelapi.user.playtime.UserPlayTimeProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public final class UserPlayTimeProviderImpl
implements UserPlayTimeProvider {
    private static final String TABLE_NAME = "user_playtime";
    private final Database database;
    private final UserPlayTimeCache cache;
    private final RefreshType all = RefreshType.USER_PLAY_TIMES;
    private final RefreshType single = RefreshType.SINGLE_USER_PLAY_TIME;

    public UserPlayTimeProviderImpl(Database database, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.cache = new UserPlayTimeCache(database, TABLE_NAME, fetchLimit, cacheCapcity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id INT PRIMARY KEY, play_time INT NOT NULL DEFAULT 0, login_count INT NOT NULL DEFAULT 0, FOREIGN KEY (id) REFERENCES users(id)");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public UserPlayTime findByUserId(int userId) {
        UserPlayTime original = this.cache.get(userId);
        return original != null ? new UserPlayTime(original) : null;
    }

    @Override
    public List<UserPlayTime> getAllPlayTimes() {
        return this.cache.getCachedPlayTimes().stream().map(UserPlayTime::new).toList();
    }

    @Override
    public UserPlayTime create(int userId) {
        if (userId < 1) {
            return null;
        }
        String sql = "INSERT INTO user_playtime (id) VALUES (?)";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, userId));
        if (row < 1) {
            return null;
        }
        UserPlayTime newPlayTime = new UserPlayTime(userId, 0, 1);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(userId));
        return newPlayTime;
    }

    @Override
    public int delete(int userId) {
        if (userId < 1) {
            return 0;
        }
        String sql = "DELETE FROM user_playtime WHERE id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, userId));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(userId));
        return row;
    }

    @Override
    public UserPlayTime update(UserPlayTime playTime) {
        if (playTime == null || playTime.getUserId() < 1 || playTime.getPlayTime() < 0 || playTime.getLoginCount() < 0) {
            return null;
        }
        UserPlayTime existing = this.cache.get(playTime.getUserId());
        if (existing == null) {
            return null;
        }
        if (Objects.equals(playTime, existing)) {
            return existing;
        }
        String sql = "UPDATE user_playtime SET play_time = ?, login_count = ? WHERE id = ?";
        int row = this.database.update(sql, stmt -> {
            stmt.setInt(1, playTime.getPlayTime());
            stmt.setInt(2, playTime.getLoginCount());
            stmt.setInt(3, playTime.getUserId());
        });
        if (row < 1) {
            return null;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(playTime.getUserId()));
        return playTime;
    }

    @Override
    public boolean updateOnlyCache(UserPlayTime playTime) {
        if (playTime == null || playTime.getUserId() < 1 || playTime.getPlayTime() < 0 || playTime.getLoginCount() < 0) {
            return false;
        }
        UserPlayTime existing = this.cache.get(playTime.getUserId());
        if (existing == null) {
            return false;
        }
        if (Objects.equals(playTime, existing)) {
            return true;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(playTime.getUserId()));
        return true;
    }

    @Override
    public void incrementPlayTime(UserPlayTime playTime) {
        int finalCurrentPlayTime;
        int row;
        if (playTime == null || playTime.getUserId() < 1 || playTime.getPlayTime() < 0 || playTime.getLoginCount() < 0) {
            return;
        }
        int currentPlayTime = playTime.getPlayTime();
        String sql = "UPDATE user_playtime SET play_time = ? WHERE id = ?";
        if ((row = this.database.update(sql, arg_0 -> UserPlayTimeProviderImpl.lambda$incrementPlayTime$3(finalCurrentPlayTime = ++currentPlayTime, playTime, arg_0))) < 1) {
            return;
        }
        playTime.setPlayTime(currentPlayTime);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(playTime.getUserId()));
    }

    private static /* synthetic */ void lambda$incrementPlayTime$3(int finalCurrentPlayTime, UserPlayTime playTime, PreparedStatement stmt) throws SQLException {
        stmt.setInt(1, finalCurrentPlayTime);
        stmt.setInt(2, playTime.getUserId());
    }
}

