/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.permission;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.library.utils.StringUtil;
import de.murmelmeister.murmelapi.user.permission.UserPermission;
import de.murmelmeister.murmelapi.user.permission.UserPermissionCache;
import de.murmelmeister.murmelapi.user.permission.UserPermissionProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class UserPermissionProviderImpl
implements UserPermissionProvider {
    private static final String TABLE_NAME = "user_permission";
    private final Database database;
    private final UserPermissionCache cache;
    private final RefreshType all = RefreshType.USER_PERMISSIONS;
    private final RefreshType single = RefreshType.SINGLE_USER_PERMISSION;

    public UserPermissionProviderImpl(Database database, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.cache = new UserPermissionCache(database, TABLE_NAME, fetchLimit, cacheCapcity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "user_id INT, permission VARCHAR(200), PRIMARY KEY (user_id, permission), expires_at DATETIME NULL, created_by INT NOT NULL, created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(), changed_by INT NULL, changed_at DATETIME NULL ON UPDATE CURRENT_TIMESTAMP(), FOREIGN KEY (user_id) REFERENCES users(id), FOREIGN KEY (created_by) REFERENCES users(id), FOREIGN KEY (changed_by) REFERENCES users(id)");
        database.update("CREATE INDEX IF NOT EXISTS idx_user_perm_userId_exp ON user_permission (expires_at, user_id)");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public UserPermission getPermission(int userId, String permission) {
        return this.cache.get(userId, permission);
    }

    @Override
    public List<UserPermission> getPermissions(int userId) {
        return this.cache.getPermissions(userId);
    }

    @Override
    public UserPermission add(int userId, String permission, long duration, int createdBy) {
        String normalizedPermission = StringUtil.normalize((String)permission);
        if (userId < 1 || normalizedPermission == null || duration < -1L || createdBy < -1) {
            return null;
        }
        String insertSql = "INSERT INTO user_permission (user_id, permission, expires_at, created_by) VALUES (?, ?, ?, ?)";
        LocalDateTime expiresAt = duration == -1L ? null : LocalDateTime.now().plusSeconds(duration);
        int row = this.database.update(insertSql, stmt -> {
            stmt.setInt(1, userId);
            stmt.setString(2, normalizedPermission);
            stmt.setTimestamp(3, expiresAt == null ? null : Timestamp.valueOf(expiresAt));
            stmt.setInt(4, createdBy);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT created_at FROM user_permission WHERE user_id = ? AND permission = ?";
        LocalDateTime createdAt = (LocalDateTime)this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("created_at").toLocalDateTime(), stmt -> {
            stmt.setInt(1, userId);
            stmt.setString(2, normalizedPermission);
        });
        if (createdAt == null) {
            return null;
        }
        UserPermission userPermission = new UserPermission(userId, normalizedPermission, expiresAt, createdBy, createdAt, null, null);
        RefreshUtil.fireSingle(this.single, new UserPermissionCache.PermissionKey(userId, normalizedPermission));
        return userPermission;
    }

    @Override
    public int remove(int userId, String permission) {
        String normalizedPermission = StringUtil.normalize((String)permission);
        if (userId < 1 || normalizedPermission == null) {
            return 0;
        }
        String sql = "DELETE FROM user_permission WHERE user_id = ? AND permission = ?";
        int row = this.database.update(sql, stmt -> {
            stmt.setInt(1, userId);
            stmt.setString(2, normalizedPermission);
        });
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, new UserPermissionCache.PermissionKey(userId, normalizedPermission));
        return row;
    }

    @Override
    public int clear(int userId) {
        if (userId < 1) {
            return 0;
        }
        String sql = "DELETE FROM user_permission WHERE user_id = ?";
        int rows = this.database.update(sql, stmt -> stmt.setInt(1, userId));
        if (rows < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(userId));
        return rows;
    }

    @Override
    public UserPermission update(int userId, String permission, long duration, int changedBy) {
        String normalizedPermission = StringUtil.normalize((String)permission);
        if (userId < 1 || normalizedPermission == null || duration < -1L || changedBy < -1) {
            return null;
        }
        LocalDateTime expiresAt = duration == -1L ? null : LocalDateTime.now().plusSeconds(duration);
        UserPermission existing = this.cache.get(userId, normalizedPermission);
        if (existing == null) {
            return null;
        }
        if (Objects.equals(expiresAt, existing.expiresAt())) {
            return existing;
        }
        String updateSql = "UPDATE user_permission SET expires_at = ?, changed_by = ? WHERE user_id = ? AND permission = ?";
        int row = this.database.update(updateSql, stmt -> {
            stmt.setTimestamp(1, expiresAt == null ? null : Timestamp.valueOf(expiresAt));
            stmt.setInt(2, changedBy);
            stmt.setInt(3, userId);
            stmt.setString(4, normalizedPermission);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT changed_at FROM user_permission WHERE user_id = ? AND permission = ?";
        LocalDateTime changedAt = (LocalDateTime)this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("changed_at").toLocalDateTime(), stmt -> {
            stmt.setInt(1, userId);
            stmt.setString(2, normalizedPermission);
        });
        if (changedAt == null) {
            return null;
        }
        UserPermission userPermission = existing.withUpdateMeta(expiresAt, changedBy, changedAt);
        RefreshUtil.fireSingle(this.single, new UserPermissionCache.PermissionKey(userId, normalizedPermission));
        return userPermission;
    }

    @Override
    public int loadExpired() {
        Set<UserPermissionCache.PermissionKey> expiredPermissions = this.cache.getCachedPermissions().stream().filter(UserPermission::isExpired).map(permission -> new UserPermissionCache.PermissionKey(permission.userId(), permission.permission())).collect(Collectors.toSet());
        if (expiredPermissions.isEmpty()) {
            return 0;
        }
        String sql = "DELETE FROM user_permission WHERE expires_at IS NOT NULL AND expires_at <= CURRENT_TIMESTAMP()";
        int removed = this.database.update(sql);
        expiredPermissions.forEach(key -> RefreshUtil.fireSingle(this.single, key));
        return removed;
    }
}

