/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.parent;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.parent.UserParent;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserParentCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private static final Pattern KEY_PATTERN = Pattern.compile(".*userId=(\\d+), parentId=(\\d+).*");
    private final Database database;
    private final String tableName;
    private final LoadingCache<ParentKey, UserParent> cacheByKey;
    private final LoadingCache<Integer, List<UserParent>> cacheByUserId;
    private final LoadingCache<String, List<UserParent>> listCache;
    private final Long fetchLimit;

    public UserParentCache(Database database, String tableName, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheByKey = CacheUtil.buildCacheRefresh(this::loadByKey, cacheCapacity, refreshInterval);
        this.cacheByUserId = CacheUtil.buildCacheRefresh(this::loadByUserId, cacheCapacity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.USER_PARENTS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_USER_PARENT.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof ParentKey) {
                    ParentKey parentKey = (ParentKey)key;
                    this.refreshSingle(parentKey);
                } else if (key instanceof Integer) {
                    Integer userId = (Integer)key;
                    this.refreshSingle(userId);
                }
            } else {
                Matcher matcher = KEY_PATTERN.matcher((String)key);
                if (matcher.matches()) {
                    int userId = Integer.parseInt(matcher.group(1));
                    int parentId = Integer.parseInt(matcher.group(2));
                    this.refreshSingle(new ParentKey(userId, parentId));
                } else {
                    int userId = Integer.parseInt((String)key);
                    this.refreshSingle(userId);
                }
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<UserParent> parents = this.loadAllFromDatabase();
        if (parents.isEmpty()) {
            return;
        }
        HashMap<Integer, List> byUser = new HashMap<Integer, List>();
        for (UserParent parent : parents) {
            ParentKey key = new ParentKey(parent.userId(), parent.parentId());
            this.cacheByKey.put((Object)key, (Object)parent);
            byUser.computeIfAbsent(parent.userId(), ignored -> new ArrayList()).add(parent);
        }
        byUser.forEach((userId, values) -> this.cacheByUserId.put(userId, List.copyOf(values)));
        this.listCache.put((Object)ALL_KEY, List.copyOf(parents));
    }

    private void refreshSingle(int userId) {
        this.remove(userId);
        List<UserParent> parents = this.loadByUserId(userId);
        parents.forEach(this::put);
    }

    private void refreshSingle(ParentKey key) {
        this.remove(key.userId(), key.parentId());
        UserParent userParent = this.loadByKey(key);
        if (userParent != null) {
            this.put(userParent);
        }
    }

    private List<UserParent> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userParent());
    }

    private List<UserParent> loadByUserId(int userId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ?";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userParent(), stmt -> stmt.setInt(1, userId));
    }

    private UserParent loadByKey(ParentKey key) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ? AND parent_id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.userParent(), stmt -> {
            stmt.setInt(1, key.userId());
            stmt.setInt(2, key.parentId());
        });
    }

    public UserParent get(int userId, int parentId) {
        return (UserParent)this.cacheByKey.get((Object)new ParentKey(userId, parentId));
    }

    public List<UserParent> getParents(int userId) {
        return (List)this.cacheByUserId.get((Object)userId);
    }

    public void put(UserParent userParent) {
        ParentKey key = new ParentKey(userParent.userId(), userParent.parentId());
        this.cacheByKey.put((Object)key, (Object)userParent);
        CacheUtil.put(this.cacheByUserId, userParent.userId(), userParent, v -> v.userId() == userParent.userId() && v.parentId() == userParent.parentId());
        CacheUtil.put(this.listCache, ALL_KEY, userParent, v -> v.userId() == userParent.userId() && v.parentId() == userParent.parentId());
    }

    public void remove(int userId, int parentId) {
        ParentKey key = new ParentKey(userId, parentId);
        this.cacheByKey.invalidate((Object)key);
        CacheUtil.remove(this.cacheByUserId, userId, v -> v.userId() == userId && v.parentId() == parentId);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.userId() == userId && v.parentId() == parentId);
    }

    public void remove(int userId) {
        this.cacheByKey.asMap().keySet().stream().filter(key -> key.userId() == userId).forEach(arg_0 -> this.cacheByKey.invalidate(arg_0));
        this.cacheByUserId.invalidate((Object)userId);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.userId() == userId);
    }

    public void clear() {
        this.cacheByKey.invalidateAll();
        this.cacheByUserId.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<UserParent> getCachedParents() {
        List parents = (List)this.listCache.get((Object)ALL_KEY);
        if (parents == null || parents.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(parents);
    }

    protected record ParentKey(int userId, int parentId) {
    }
}

