/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user;

import de.murmelmeister.murmelapi.exceptions.user.UserException;
import de.murmelmeister.murmelapi.exceptions.user.UserPlayTimeException;
import de.murmelmeister.murmelapi.exceptions.user.UserSessionException;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.user.UserProvider;
import de.murmelmeister.murmelapi.user.login.UserLoginProvider;
import de.murmelmeister.murmelapi.user.playtime.UserPlayTime;
import de.murmelmeister.murmelapi.user.playtime.UserPlayTimeProvider;
import de.murmelmeister.murmelapi.user.session.UserSession;
import de.murmelmeister.murmelapi.user.session.UserSessionProvider;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;

public final class UserService {
    private final UserProvider userProvider;
    private final UserPlayTimeProvider playTimeProvider;
    private final UserLoginProvider loginProvider;
    private final UserSessionProvider sessionProvider;

    public UserService(UserProvider userProvider, UserPlayTimeProvider playTimeProvider, UserLoginProvider loginProvider, UserSessionProvider sessionProvider) {
        this.userProvider = userProvider;
        this.playTimeProvider = playTimeProvider;
        this.loginProvider = loginProvider;
        this.sessionProvider = sessionProvider;
    }

    public void startSession(int userId, String ipAddress, String clientBrand, int protocolVersion) {
        if (userId < 1 || ipAddress == null) {
            throw new IllegalArgumentException("Invalid parameters for session handling");
        }
        UserSession session = this.sessionProvider.findByUserId(userId);
        if (session != null) {
            if (!this.isSessionAlreadyLogged(session)) {
                this.loginProvider.create(session);
            }
            this.deleteSessionOrThrowIfStillPresent(session);
        }
        this.sessionProvider.create(userId, ipAddress, clientBrand, protocolVersion);
    }

    public void closeSession(int userId) {
        if (userId < 1) {
            throw new IllegalArgumentException("User ID must be greater than 0");
        }
        UserSession session = this.sessionProvider.findByUserId(userId);
        if (session != null) {
            if (!this.isSessionAlreadyLogged(session)) {
                this.loginProvider.create(session);
            }
            this.deleteSessionOrThrowIfStillPresent(session);
        }
    }

    public void loginStreak(int userId) {
        if (userId < 1) {
            throw new IllegalArgumentException("User ID must be greater than 0");
        }
        UserPlayTime playTime = this.playTimeProvider.findByUserId(userId);
        if (playTime == null) {
            throw new UserPlayTimeException("Play time not found for user ID: " + userId);
        }
        LocalDate today = LocalDate.now();
        LocalDate lastSeen = playTime.getLastSeenDate();
        if (lastSeen == null || lastSeen.plusDays(1L).equals(today)) {
            playTime.setLoginCount(playTime.getLoginCount() + 1);
        } else if (!lastSeen.equals(today)) {
            playTime.setLoginCount(1);
        }
        playTime.setLastSeenDate(today);
        if (this.playTimeProvider.update(playTime) == null) {
            throw new UserPlayTimeException("Failed to update play time for user ID: " + userId);
        }
    }

    public void checkLoginStreakWhileOnline(int userId, UserPlayTime playTime) {
        if (userId < 1 || playTime == null) {
            return;
        }
        LocalDate today = LocalDate.now();
        LocalDate lastSeen = playTime.getLastSeenDate();
        if (lastSeen == null || lastSeen.isBefore(today)) {
            if (lastSeen != null && lastSeen.plusDays(1L).equals(today)) {
                playTime.setLoginCount(playTime.getLoginCount() + 1);
            } else {
                playTime.setLoginCount(1);
            }
            playTime.setLastSeenDate(today);
            if (this.playTimeProvider.update(playTime) == null) {
                throw new UserPlayTimeException("Failed to update play time for user ID: " + userId);
            }
        }
    }

    public User join(UUID uuid, String username) {
        LocalDateTime firstJoin;
        UserPlayTime playTime;
        if (uuid == null || username == null) {
            throw new IllegalArgumentException("UUID and username cannot be null");
        }
        User user = this.userProvider.findByMojangId(uuid);
        if (user == null) {
            user = this.userProvider.create(uuid, username);
            if (user == null) {
                throw new UserException("Failed to create user with UUID: " + String.valueOf(uuid));
            }
            this.userProvider.update(user.id(), username, LocalDateTime.now(), user.debugUser(), user.debugEnabled(), user.languageId());
        }
        if ((playTime = this.playTimeProvider.findByUserId(user.id())) == null && (playTime = this.playTimeProvider.create(user.id())) == null) {
            throw new UserPlayTimeException("Failed to create play time for user with ID: " + user.id());
        }
        String currentUsername = user.username();
        if (currentUsername == null || !currentUsername.equals(username)) {
            this.userProvider.update(user.id(), username, user.firstLogin(), user.debugUser(), user.debugEnabled(), user.languageId());
        }
        if ((firstJoin = user.firstLogin()) == null) {
            this.userProvider.update(user.id(), user.username(), LocalDateTime.now(), user.debugUser(), user.debugEnabled(), user.languageId());
        }
        if (playTime.getLastSeenDate() == null) {
            LocalDateTime lastLogin = this.loginProvider.getLastLoginTime(user.id());
            LocalDate lastSeen = lastLogin != null ? lastLogin.toLocalDate() : LocalDate.now();
            playTime.setLastSeenDate(lastSeen);
            if (!this.playTimeProvider.updateOnlyCache(playTime)) {
                throw new UserPlayTimeException("Failed to update last seen date for user with ID: " + user.id());
            }
        }
        return user;
    }

    private boolean isSessionAlreadyLogged(UserSession session) {
        return this.loginProvider.findById(session.id()) != null;
    }

    private void deleteSessionOrThrowIfStillPresent(UserSession session) {
        int rows = this.sessionProvider.delete(session.id());
        if (rows > 0) {
            return;
        }
        this.sessionProvider.refreshCache();
        if (this.sessionProvider.findByUserId(session.userId()) != null) {
            throw new UserSessionException("Failed to delete session for user ID: " + session.userId());
        }
    }
}

