/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.library.utils.StringUtil;
import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.user.UserCache;
import de.murmelmeister.murmelapi.user.UserProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class UserProviderImpl
implements UserProvider {
    private static final String TABLE_NAME = "users";
    private final Database database;
    private final UserCache cache;
    private final RefreshType all = RefreshType.USERS;
    private final RefreshType single = RefreshType.SINGLE_USER;

    public UserProviderImpl(Database database, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.cache = new UserCache(database, TABLE_NAME, fetchLimit, cacheCapacity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id INT PRIMARY KEY AUTO_INCREMENT, mojang_id VARCHAR(36) NOT NULL UNIQUE, username VARCHAR(16) NOT NULL, first_login DATETIME NULL, system_user BOOLEAN NOT NULL DEFAULT FALSE, debug_user BOOLEAN NOT NULL DEFAULT FALSE, debug_enabled BOOLEAN NOT NULL DEFAULT FALSE, language_id INT NOT NULL DEFAULT 1, FOREIGN KEY (language_id) REFERENCES languages(id)");
        database.update("CREATE INDEX IF NOT EXISTS idx_users_username ON users (username)");
    }

    public static void createConsoleUser(Database database) {
        String sql = "INSERT IGNORE INTO users VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        database.update(sql, stmt -> {
            stmt.setInt(1, -1);
            stmt.setString(2, new UUID(0L, 0L).toString());
            stmt.setString(3, "Console");
            stmt.setNull(4, 93);
            stmt.setBoolean(5, true);
            stmt.setBoolean(6, true);
            stmt.setBoolean(7, true);
            stmt.setInt(8, 1);
        });
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public User findById(int userId) {
        return this.cache.getById(userId);
    }

    @Override
    public User findByMojangId(UUID uuid) {
        return this.cache.getByUUID(uuid);
    }

    @Override
    public User findByUsername(String username) {
        return this.cache.getByName(username);
    }

    @Override
    public List<User> findAll() {
        return this.cache.getCachedUsers().stream().filter(user -> user.id() != -1).toList();
    }

    @Override
    public List<UUID> findMojangIds() {
        return this.findAll().stream().map(User::mojangId).filter(Objects::nonNull).toList();
    }

    @Override
    public List<String> findUsernames() {
        return this.findAll().stream().map(User::username).filter(Objects::nonNull).toList();
    }

    @Override
    public User create(UUID uuid, String username) {
        String normalizedUsername = StringUtil.normalize((String)username);
        if (uuid == null || normalizedUsername == null) {
            return null;
        }
        String sql = "INSERT INTO users (mojang_id, username) VALUES (?, ?)";
        int id = (int)this.database.updateAndGetGeneratedKeys(sql, stmt -> {
            stmt.setString(1, uuid.toString());
            stmt.setString(2, normalizedUsername);
        });
        if (id < 1) {
            return null;
        }
        User newUser = new User(id, uuid, normalizedUsername, null, false, false, false, 1);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(newUser.id()));
        return newUser;
    }

    @Override
    public int delete(int userId) {
        if (userId < 1) {
            return 0;
        }
        String sql = "DELETE FROM users WHERE id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, userId));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(userId));
        return row;
    }

    @Override
    public User update(int userId, String username, LocalDateTime firstLogin, boolean debugUser, boolean debugEnabled, int languageId) {
        String normalizedUsername = StringUtil.normalize((String)username);
        if (userId < 1 || firstLogin == null || normalizedUsername == null || languageId < 1) {
            return null;
        }
        User existing = this.cache.getById(userId);
        if (existing == null) {
            return null;
        }
        if (Objects.equals(normalizedUsername, existing.username()) && Objects.equals(firstLogin, existing.firstLogin()) && debugUser == existing.debugUser() && debugEnabled == existing.debugEnabled() && languageId == existing.languageId()) {
            return existing;
        }
        String sql = "UPDATE users SET mojang_id = ?, username = ?, first_login = ?, debug_user = ?, debug_enabled = ?, language_id = ? WHERE id = ?";
        int row = this.database.update(sql, stmt -> {
            stmt.setString(1, existing.mojangId().toString());
            stmt.setString(2, normalizedUsername);
            stmt.setTimestamp(3, Timestamp.valueOf(firstLogin));
            stmt.setBoolean(4, debugUser);
            stmt.setBoolean(5, debugEnabled);
            stmt.setInt(6, languageId);
            stmt.setInt(7, userId);
        });
        if (row < 1) {
            return null;
        }
        User user = existing.withUpdateMeta(normalizedUsername, firstLogin, debugUser, debugEnabled, languageId);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(userId));
        return user;
    }
}

