/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment.reason;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReason;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PunishmentReasonCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<Integer, PunishmentReason> cacheById;
    private final LoadingCache<Integer, List<PunishmentReason>> cacheByType;
    private final LoadingCache<String, List<PunishmentReason>> listCache;
    private final Long fetchLimit;

    public PunishmentReasonCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheById = CacheUtil.buildCacheRefresh(this::loadById, cacheCapcity, refreshInterval);
        this.cacheByType = CacheUtil.buildCacheRefresh(this::loadByType, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.PUNISHMENT_REASONS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_PUNISHMENT_REASON.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof Integer) {
                    Integer reasonId = (Integer)key;
                    this.refreshSingle(reasonId);
                }
            } else {
                int reasonId = Integer.parseInt((String)key);
                this.refreshSingle(reasonId);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<PunishmentReason> reasons = this.loadAllFromDatabase();
        if (reasons.isEmpty()) {
            return;
        }
        HashMap<Integer, List> byType = new HashMap<Integer, List>();
        for (PunishmentReason reason : reasons) {
            this.cacheById.put((Object)reason.id(), (Object)reason);
            byType.computeIfAbsent(reason.typeId(), ignored -> new ArrayList()).add(reason);
        }
        byType.forEach((typeId, values) -> this.cacheByType.put(typeId, List.copyOf(values)));
        this.listCache.put((Object)ALL_KEY, List.copyOf(reasons));
    }

    private void refreshSingle(int reasonId) {
        this.remove(reasonId);
        PunishmentReason reason = this.loadById(reasonId);
        if (reason != null) {
            this.put(reason);
        }
    }

    private List<PunishmentReason> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentReason());
    }

    private List<PunishmentReason> loadByType(int typeId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE type_id = ?";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentReason(), stmt -> stmt.setInt(1, typeId));
    }

    private PunishmentReason loadById(int reasonId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentReason(), stmt -> stmt.setInt(1, reasonId));
    }

    public PunishmentReason getById(int reasonId) {
        return (PunishmentReason)this.cacheById.get((Object)reasonId);
    }

    public List<PunishmentReason> getByType(int typeId) {
        return (List)this.cacheByType.get((Object)typeId);
    }

    public void put(PunishmentReason reason) {
        int reasonId = reason.id();
        this.cacheById.put((Object)reasonId, (Object)reason);
        CacheUtil.put(this.cacheByType, reason.typeId(), reason, v -> v.id() == reasonId);
        CacheUtil.put(this.listCache, ALL_KEY, reason, v -> v.id() == reasonId);
    }

    public void remove(int reasonId) {
        PunishmentReason reason = (PunishmentReason)this.cacheById.getIfPresent((Object)reasonId);
        if (reason != null) {
            this.cacheById.invalidate((Object)reasonId);
            CacheUtil.remove(this.cacheByType, reason.typeId(), v -> v.id() == reasonId);
        }
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.id() == reasonId);
    }

    public void clear() {
        this.cacheById.invalidateAll();
        this.cacheByType.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<PunishmentReason> getCachedPunishReasons() {
        List reasons = (List)this.listCache.get((Object)ALL_KEY);
        if (reasons == null || reasons.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(reasons);
    }
}

