/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment.audit;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.punishment.audit.PunishmentLog;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class PunishmentLogCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<UUID, PunishmentLog> cacheById;
    private final LoadingCache<Integer, List<PunishmentLog>> cacheByUser;
    private final LoadingCache<String, List<PunishmentLog>> cacheByIp;
    private final LoadingCache<String, List<PunishmentLog>> listCache;
    private final Long fetchLimit;

    public PunishmentLogCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheById = CacheUtil.buildCacheRefresh(this::loadById, cacheCapcity, refreshInterval);
        this.cacheByUser = CacheUtil.buildCacheRefresh(this::loadByUserId, cacheCapcity, refreshInterval);
        this.cacheByIp = CacheUtil.buildCacheRefresh(this::loadByIpAddress, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.PUNISHMENT_LOGS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_PUNISHMENT_LOG.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof UUID) {
                    UUID logId = (UUID)key;
                    this.refreshSingle(logId);
                }
            } else {
                UUID logId = UUID.fromString((String)key);
                this.refreshSingle(logId);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<PunishmentLog> logs = this.loadAllFromDatabase();
        if (logs.isEmpty()) {
            return;
        }
        HashMap<Integer, List> byUser = new HashMap<Integer, List>();
        HashMap<String, List> byIp = new HashMap<String, List>();
        for (PunishmentLog log : logs) {
            String ipAddress;
            this.cacheById.put((Object)log.id(), (Object)log);
            Integer userId2 = log.userId();
            if (userId2 != null) {
                byUser.computeIfAbsent(userId2, ignored -> new ArrayList()).add(log);
            }
            if ((ipAddress = log.ipAddress()) == null) continue;
            byIp.computeIfAbsent(ipAddress, ignored -> new ArrayList()).add(log);
        }
        byUser.forEach((userId, userLogs) -> this.cacheByUser.put(userId, List.copyOf(userLogs)));
        byIp.forEach((ip, ipLogs) -> this.cacheByIp.put(ip, List.copyOf(ipLogs)));
        this.listCache.put((Object)ALL_KEY, List.copyOf(logs));
    }

    private void refreshSingle(UUID logId) {
        this.remove(logId);
        PunishmentLog log = this.loadById(logId);
        if (log != null) {
            this.put(log);
        }
    }

    private List<PunishmentLog> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName + " ORDER BY created_at DESC";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentLog());
    }

    private List<PunishmentLog> loadByUserId(int userId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ? ORDER BY created_at DESC";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentLog(), stmt -> stmt.setInt(1, userId));
    }

    private List<PunishmentLog> loadByIpAddress(String ipAddress) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE ip_address = ? ORDER BY created_at DESC";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentLog(), stmt -> stmt.setString(1, ipAddress));
    }

    private PunishmentLog loadById(UUID id) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.punishmentLog(), stmt -> stmt.setString(1, id.toString()));
    }

    public PunishmentLog getById(UUID logId) {
        return (PunishmentLog)this.cacheById.get((Object)logId);
    }

    public List<PunishmentLog> getByUser(int userId) {
        return (List)this.cacheByUser.get((Object)userId);
    }

    public List<PunishmentLog> getByIp(String ipAddress) {
        return (List)this.cacheByIp.get((Object)ipAddress);
    }

    public void put(PunishmentLog log) {
        UUID logId = log.id();
        this.cacheById.put((Object)logId, (Object)log);
        CacheUtil.put(this.cacheByUser, log.userId(), log, v -> v.id().equals(logId));
        CacheUtil.put(this.cacheByIp, log.ipAddress(), log, v -> v.id().equals(logId));
        CacheUtil.put(this.listCache, ALL_KEY, log, v -> v.id().equals(logId));
    }

    public void remove(UUID logId) {
        PunishmentLog log = (PunishmentLog)this.cacheById.getIfPresent((Object)logId);
        if (log != null) {
            this.cacheById.invalidate((Object)logId);
            CacheUtil.remove(this.cacheByUser, log.userId(), v -> v.id().equals(logId));
            CacheUtil.remove(this.cacheByIp, log.ipAddress(), v -> v.id().equals(logId));
        }
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.id().equals(logId));
    }

    public void clear() {
        this.cacheById.invalidateAll();
        this.cacheByUser.invalidateAll();
        this.cacheByIp.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<PunishmentLog> getCachedPunishLogs() {
        List logs = (List)this.listCache.get((Object)ALL_KEY);
        if (logs == null || logs.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(logs);
    }
}

