/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.language.message;

import de.murmelmeister.murmelapi.language.message.MessageProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum MurmelMessage {
    TIME_SECOND_SINGULAR(LocalizedMessage.of(1, "second"), LocalizedMessage.of(2, "Sekunde")),
    TIME_SECOND_PLURAL(LocalizedMessage.of(1, "seconds"), LocalizedMessage.of(2, "Sekunden")),
    TIME_MINUTE_SINGULAR(LocalizedMessage.of(1, "minute"), LocalizedMessage.of(2, "Minute")),
    TIME_MINUTE_PLURAL(LocalizedMessage.of(1, "minutes"), LocalizedMessage.of(2, "Minuten")),
    TIME_HOUR_SINGULAR(LocalizedMessage.of(1, "hour"), LocalizedMessage.of(2, "Stunde")),
    TIME_HOUR_PLURAL(LocalizedMessage.of(1, "hours"), LocalizedMessage.of(2, "Stunden")),
    TIME_DAY_SINGULAR(LocalizedMessage.of(1, "day"), LocalizedMessage.of(2, "Tag")),
    TIME_DAY_PLURAL(LocalizedMessage.of(1, "days"), LocalizedMessage.of(2, "Tage")),
    TIME_YEAR_SINGULAR(LocalizedMessage.of(1, "year"), LocalizedMessage.of(2, "Jahr")),
    TIME_YEAR_PLURAL(LocalizedMessage.of(1, "years"), LocalizedMessage.of(2, "Jahre")),
    DATE_TIME_FORMAT(LocalizedMessage.of(1, "dd.MM.yyyy HH:mm:ss"), LocalizedMessage.of(2, "dd.MM.yyyy HH:mm:ss"));

    private static final MurmelMessage[] VALUES;
    private final Map<Integer, String> messages;

    private MurmelMessage(LocalizedMessage ... entries) {
        HashMap<Integer, String> messageMap = new HashMap<Integer, String>();
        for (LocalizedMessage entry : entries) {
            messageMap.put(entry.languageId(), entry.message());
        }
        this.messages = Collections.unmodifiableMap(messageMap);
    }

    public String getTag() {
        return this.name().toLowerCase().replace('_', '.');
    }

    public Map<Integer, String> getMessages() {
        return this.messages;
    }

    public static void loadMessages(MessageProvider provider) {
        for (MurmelMessage message : VALUES) {
            String tag = message.getTag();
            message.getMessages().forEach((languageId, msg) -> {
                if (provider.get(tag, (int)languageId) == null) {
                    provider.create(tag, (int)languageId, (String)msg);
                }
            });
        }
    }

    static {
        VALUES = MurmelMessage.values();
    }

    record LocalizedMessage(int languageId, String message) {
        public static LocalizedMessage of(int languageId, String message) {
            return new LocalizedMessage(languageId, message);
        }
    }
}

