/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.language;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.language.Language;
import de.murmelmeister.murmelapi.language.LanguageCache;
import de.murmelmeister.murmelapi.language.LanguageProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.util.List;
import java.util.Objects;

public final class LanguageProviderImpl
implements LanguageProvider {
    private static final String TABLE_NAME = "languages";
    private final Database database;
    private final LanguageCache cache;
    private final RefreshType all = RefreshType.LANGUAGES;
    private final RefreshType single = RefreshType.SINGLE_LANGUAGE;

    public LanguageProviderImpl(Database database, long cacheCapacity) {
        this.database = database;
        this.cache = new LanguageCache(database, TABLE_NAME, cacheCapacity);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id INT PRIMARY KEY AUTO_INCREMENT, code VARCHAR(32) UNIQUE");
    }

    public static void createDefaultLanguages(Database database) {
        String upsertDefaults = "INSERT INTO languages (id, code) VALUES (?, ?) ON DUPLICATE KEY UPDATE code = VALUES(code)";
        database.updateBatch(upsertDefaults, stmt -> {
            stmt.setInt(1, 1);
            stmt.setString(2, "en-US");
            stmt.addBatch();
            stmt.setInt(1, 2);
            stmt.setString(2, "de-DE");
            stmt.addBatch();
        });
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public Language get(int id) {
        return this.cache.getById(id);
    }

    @Override
    public Language get(String code) {
        String normalized = this.normalize(code);
        return normalized != null ? this.cache.getByCode(normalized) : null;
    }

    @Override
    public List<Language> getLanguages() {
        return this.cache.getCachedLanguages();
    }

    @Override
    public Language create(String code) {
        String normalized = this.normalize(code);
        if (normalized == null) {
            return null;
        }
        String sql = "INSERT INTO languages (code) VALUES (?)";
        int id = (int)this.database.updateAndGetGeneratedKeys(sql, stmt -> stmt.setString(1, normalized));
        if (id < 1) {
            return null;
        }
        Language language = new Language(id, normalized);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(id));
        return language;
    }

    @Override
    public int delete(int id) {
        if (id < 1 || id == 1 || id == 2) {
            return 0;
        }
        String sql = "DELETE FROM languages WHERE id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, id));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(id));
        return row;
    }

    @Override
    public Language update(int id, String code) {
        if (id < 1 || code == null) {
            return null;
        }
        String normalized = this.normalize(code);
        if (normalized == null) {
            return null;
        }
        if (id == 1 && !"en-US".equals(normalized) || id == 2 && !"de-DE".equals(normalized)) {
            return null;
        }
        Language existing = this.cache.getById(id);
        if (existing == null) {
            return null;
        }
        if (Objects.equals(normalized, existing.code())) {
            return existing;
        }
        String sql = "UPDATE languages SET code = ? WHERE id = ?";
        int rows = this.database.update(sql, stmt -> {
            stmt.setString(1, normalized);
            stmt.setInt(2, id);
        });
        if (rows < 1) {
            return null;
        }
        Language language = existing.withCode(normalized);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(id));
        return language;
    }

    private String normalize(String code) {
        if (code == null) {
            return null;
        }
        if (code.isBlank()) {
            return null;
        }
        return code;
    }
}

