/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.language;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.language.Language;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.util.Collections;
import java.util.List;

public class LanguageCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<Integer, Language> cacheById;
    private final LoadingCache<String, Integer> codeToId;
    private final LoadingCache<String, List<Language>> listCache;

    public LanguageCache(Database database, String tableName, long cacheCapacity) {
        this.database = database;
        this.tableName = tableName;
        this.cacheById = CacheUtil.buildCache(this::loadById, cacheCapacity);
        this.codeToId = CacheUtil.buildCache(this::loadByCodeKey, cacheCapacity);
        this.listCache = CacheUtil.buildCache(key -> this.loadAllFromDatabase(), 1L);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.LANGUAGES.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_LANGUAGE.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof Integer) {
                    Integer id = (Integer)key;
                    this.refreshSingle(id);
                }
            } else {
                int id = Integer.parseInt((String)key);
                this.refreshSingle(id);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<Language> languages = this.loadAllFromDatabase();
        if (languages.isEmpty()) {
            return;
        }
        languages.forEach(language -> {
            this.cacheById.put((Object)language.id(), language);
            this.codeToId.put((Object)LanguageCache.toKey(language.code()), (Object)language.id());
        });
        this.listCache.put((Object)ALL_KEY, List.copyOf(languages));
    }

    private void refreshSingle(int id) {
        this.remove(id);
        Language language = this.loadById(id);
        if (language != null) {
            this.put(language);
        }
    }

    private List<Language> loadAllFromDatabase() {
        String sql = "SELECT id, code FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, null, ResultSetUtil.language());
    }

    private Integer loadByCodeKey(String key) {
        String sql = "SELECT id FROM " + this.tableName + " WHERE LOWER(code) = ?";
        return (Integer)CacheUtil.loadSingle(this.database, sql, null, resultSet -> resultSet.getInt("id"), stmt -> stmt.setString(1, key));
    }

    private Language loadById(int id) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, null, ResultSetUtil.language(), stmt -> stmt.setInt(1, id));
    }

    public Language getById(int id) {
        return (Language)this.cacheById.get((Object)id);
    }

    public Language getByCode(String code) {
        if (code == null) {
            return null;
        }
        Integer id = (Integer)this.codeToId.get((Object)LanguageCache.toKey(code));
        return id != null ? (Language)this.cacheById.get((Object)id) : null;
    }

    public void put(Language language) {
        this.cacheById.put((Object)language.id(), (Object)language);
        this.codeToId.put((Object)LanguageCache.toKey(language.code()), (Object)language.id());
        CacheUtil.put(this.listCache, ALL_KEY, language, v -> v.id() == language.id());
    }

    public void remove(int id) {
        Language removed = (Language)this.cacheById.getIfPresent((Object)id);
        if (removed != null) {
            this.cacheById.invalidate((Object)id);
            this.codeToId.invalidate((Object)LanguageCache.toKey(removed.code()));
        }
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.id() == id);
    }

    public void clear() {
        this.cacheById.invalidateAll();
        this.codeToId.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<Language> getCachedLanguages() {
        List languages = (List)this.listCache.get((Object)ALL_KEY);
        if (languages == null || languages.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(languages);
    }

    private static String toKey(String code) {
        return code.toLowerCase();
    }
}

