/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class GroupCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<Integer, Group> cacheById;
    private final LoadingCache<String, Group> cacheByName;
    private final LoadingCache<String, List<Group>> listCache;
    private final Long fetchLimit;

    public GroupCache(Database database, String tableName, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheById = CacheUtil.buildCacheRefresh(this::loadById, cacheCapacity, refreshInterval);
        this.cacheByName = CacheUtil.buildCacheRefresh(this::loadByName, cacheCapacity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), cacheCapacity, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.GROUPS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_GROUP.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof Integer) {
                    Integer id = (Integer)key;
                    this.refreshSingle(id);
                }
            } else {
                int id = Integer.parseInt((String)key);
                this.refreshSingle(id);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<Group> groups = this.loadAllFromDatabase();
        if (groups.isEmpty()) {
            return;
        }
        groups.forEach(group -> {
            this.cacheById.put((Object)group.id(), group);
            this.cacheByName.put((Object)group.groupName(), group);
        });
        this.listCache.put((Object)ALL_KEY, List.copyOf(groups));
    }

    private void refreshSingle(int id) {
        this.remove(id);
        Group group = this.loadById(id);
        if (group != null) {
            this.put(group);
        }
    }

    private List<Group> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.group());
    }

    private Group loadByName(String name) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE group_name = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.group(), stmt -> stmt.setString(1, name));
    }

    private Group loadById(int id) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.group(), stmt -> stmt.setInt(1, id));
    }

    public Group getById(int id) {
        return (Group)this.cacheById.get((Object)id);
    }

    public Group getByName(String name) {
        return (Group)this.cacheByName.get((Object)name);
    }

    public void put(Group group) {
        this.cacheById.put((Object)group.id(), (Object)group);
        this.cacheByName.put((Object)group.groupName(), (Object)group);
        CacheUtil.put(this.listCache, ALL_KEY, group, v -> v.id() == group.id());
    }

    public void remove(int id) {
        Group group = (Group)this.cacheById.getIfPresent((Object)id);
        if (group != null) {
            this.cacheById.invalidate((Object)id);
            this.cacheByName.invalidate((Object)group.groupName());
        }
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.id() == id);
    }

    public void clear() {
        this.cacheById.invalidateAll();
        this.cacheByName.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<Group> getCachedGroups() {
        List groups = (List)this.listCache.get((Object)ALL_KEY);
        if (groups == null || groups.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(groups);
    }
}

