/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.session;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.user.session.UserSession;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class UserSessionCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private final Database database;
    private final String tableName;
    private final LoadingCache<UUID, UserSession> cacheById;
    private final LoadingCache<Integer, UserSession> cacheByUserId;
    private final LoadingCache<String, List<UserSession>> listCache;
    private final Long fetchLimit;

    public UserSessionCache(Database database, String tableName, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheById = CacheUtil.buildCacheRefresh(this::loadById, cacheCapcity, refreshInterval);
        this.cacheByUserId = CacheUtil.buildCacheRefresh(this::loadByUserId, cacheCapcity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.USER_SESSIONS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_USER_SESSION.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof UUID) {
                    UUID sessionId = (UUID)key;
                    this.refreshSingle(sessionId);
                }
            } else {
                UUID sessionId = UUID.fromString((String)key);
                this.refreshSingle(sessionId);
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<UserSession> sessions = this.loadAllFromDatabase();
        if (sessions.isEmpty()) {
            return;
        }
        sessions.forEach(session -> {
            this.cacheById.put(session.id(), (UserSession)session);
            this.cacheByUserId.put(session.userId(), (UserSession)session);
        });
        this.listCache.put(ALL_KEY, List.copyOf(sessions));
    }

    private void refreshSingle(UUID sessionId) {
        this.remove(sessionId);
        UserSession session = this.loadById(sessionId);
        if (session != null) {
            this.put(session);
        }
    }

    private List<UserSession> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.userSession());
    }

    private UserSession loadByUserId(int userId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE user_id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.userSession(), stmt -> stmt.setInt(1, userId));
    }

    private UserSession loadById(UUID sessionId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.userSession(), stmt -> stmt.setString(1, sessionId.toString()));
    }

    public UserSession getById(UUID sessionId) {
        return this.cacheById.get(sessionId);
    }

    public UserSession getByUserId(int userId) {
        return this.cacheByUserId.get(userId);
    }

    public void put(UserSession session) {
        this.cacheById.put(session.id(), session);
        this.cacheByUserId.put(session.userId(), session);
        CacheUtil.put(this.listCache, ALL_KEY, session, v -> v.id().equals(session.id()));
    }

    public void remove(UUID sessionId) {
        UserSession session = (UserSession)this.cacheById.getIfPresent(sessionId);
        this.cacheById.invalidate(sessionId);
        if (session != null) {
            this.cacheByUserId.invalidate(session.userId());
        }
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.id().equals(sessionId));
    }

    public void clear() {
        this.cacheById.invalidateAll();
        this.cacheByUserId.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<UserSession> getCachedSessions() {
        List<UserSession> sessions = this.listCache.get(ALL_KEY);
        if (sessions == null || sessions.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(sessions);
    }
}

