/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.settings;

import com.google.gson.Gson;
import de.murmelmeister.murmelapi.settings.Settings;
import de.murmelmeister.murmelapi.settings.SettingsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SettingsService {
    private final Logger logger = LoggerFactory.getLogger(SettingsService.class);
    private final SettingsProvider provider;
    private final Gson gson;

    public SettingsService(SettingsProvider provider) {
        this.provider = provider;
        this.gson = new Gson();
    }

    public <T> T get(String tagId, Class<T> type, T defaultValue) {
        Settings settings = this.provider.get(tagId);
        if (settings == null) {
            return defaultValue;
        }
        try {
            return this.gson.fromJson(settings.json(), type);
        }
        catch (Exception e) {
            this.logger.warn("Invalid JSON for setting {}: {}", tagId, settings.json(), e);
            return defaultValue;
        }
    }

    public <T> T get(String tagId, Class<T> type) {
        return this.get(tagId, type, null);
    }

    public <T> T get(Settings settings, Class<T> type) {
        return this.get(settings.tagId(), type);
    }

    public <T> Settings set(String tagId, T value) {
        String json = this.gson.toJson(value);
        return this.provider.upsert(new Settings(tagId, json, null));
    }

    public int delete(String tagId) {
        return this.provider.delete(tagId);
    }
}

