/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.punishment;

import de.murmelmeister.murmelapi.exceptions.punishment.PunishmentException;
import de.murmelmeister.murmelapi.punishment.audit.PunishmentLog;
import de.murmelmeister.murmelapi.punishment.audit.PunishmentLogProvider;
import de.murmelmeister.murmelapi.punishment.ip.PunishmentCurrentIp;
import de.murmelmeister.murmelapi.punishment.ip.PunishmentCurrentIpProvider;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReason;
import de.murmelmeister.murmelapi.punishment.reason.PunishmentReasonProvider;
import de.murmelmeister.murmelapi.punishment.user.PunishmentCurrentUser;
import de.murmelmeister.murmelapi.punishment.user.PunishmentCurrentUserProvider;
import java.util.UUID;

public final class PunishmentService {
    private final PunishmentReasonProvider reasonProvider;
    private final PunishmentLogProvider logProvider;
    private final PunishmentCurrentIpProvider ipProvider;
    private final PunishmentCurrentUserProvider userProvider;

    public PunishmentService(PunishmentReasonProvider reasonProvider, PunishmentLogProvider logProvider, PunishmentCurrentIpProvider ipProvider, PunishmentCurrentUserProvider userProvider) {
        this.reasonProvider = reasonProvider;
        this.logProvider = logProvider;
        this.ipProvider = ipProvider;
        this.userProvider = userProvider;
    }

    public int punishedUser(int userId, int reasonId, int createdBy) {
        PunishmentLog log;
        PunishmentReason reason = this.reasonProvider.getReason(reasonId);
        PunishmentLog punishmentLog = log = reason == null ? null : this.logProvider.create(userId, null, reason, createdBy);
        if (log == null) {
            throw new PunishmentException("Failed to create punishment log for user: " + userId + " with reason: " + reasonId);
        }
        PunishmentCurrentUser punish = this.userProvider.create(userId, log.reasonTypeId(), log.id());
        if (punish == null) {
            throw new PunishmentException("Failed to create punishment user: " + userId + " with reason: " + reasonId);
        }
        return 2;
    }

    public int updatedPunishedUser(int userId, int reasonId, int createdBy) {
        PunishmentCurrentUser updated;
        PunishmentLog log;
        PunishmentReason reason = this.reasonProvider.getReason(reasonId);
        PunishmentLog punishmentLog = log = reason == null ? null : this.logProvider.modify(userId, null, reason, createdBy);
        if (log == null) {
            throw new PunishmentException("Failed to update punishment log for user: " + userId + " with reason: " + reasonId);
        }
        PunishmentCurrentUser punish = this.userProvider.getPunishedUser(userId, log.reasonTypeId());
        PunishmentCurrentUser punishmentCurrentUser = updated = punish == null ? null : this.userProvider.update(punish.userId(), punish.typeId(), log.id());
        if (updated == null) {
            throw new PunishmentException("Failed to update punishment user: " + userId + " with reason: " + reasonId);
        }
        return 2;
    }

    public int punishedIp(String ipAddress, int reasonId, int createdBy) {
        PunishmentLog log;
        PunishmentReason reason = this.reasonProvider.getReason(reasonId);
        PunishmentLog punishmentLog = log = reason == null ? null : this.logProvider.create(null, ipAddress, reason, createdBy);
        if (log == null) {
            throw new PunishmentException("Failed to create punishment log for IP: " + ipAddress + " with reason: " + reasonId);
        }
        PunishmentCurrentIp punish = this.ipProvider.create(ipAddress, log.reasonTypeId(), log.id());
        if (punish == null) {
            throw new PunishmentException("Failed to create punishment IP: " + ipAddress + " with reason: " + reasonId);
        }
        return 2;
    }

    public int updatedPunishedIp(String ipAddress, int reasonId, int createdBy) {
        PunishmentCurrentIp updated;
        PunishmentLog log;
        PunishmentReason reason = this.reasonProvider.getReason(reasonId);
        PunishmentLog punishmentLog = log = reason == null ? null : this.logProvider.modify(null, ipAddress, reason, createdBy);
        if (log == null) {
            throw new PunishmentException("Failed to update punishment log for IP: " + ipAddress + " with reason: " + reasonId);
        }
        PunishmentCurrentIp punish = this.ipProvider.getPunishedIp(ipAddress, log.reasonTypeId());
        PunishmentCurrentIp punishmentCurrentIp = updated = punish == null ? null : this.ipProvider.update(punish.ipAddress(), punish.typeId(), log.id());
        if (updated == null) {
            throw new PunishmentException("Failed to update punishment IP: " + ipAddress + " with reason: " + reasonId);
        }
        return 2;
    }

    public int unpunishedUser(int userId, int typeId, UUID logId, int changedBy) {
        PunishmentLog currentLog = this.logProvider.getLog(logId);
        if (currentLog == null) {
            throw new PunishmentException("Punishment log not found for user: " + userId + " with type: " + typeId);
        }
        PunishmentLog revokeLog = this.logProvider.revoke(userId, null, currentLog, changedBy);
        if (revokeLog == null) {
            throw new PunishmentException("Failed to revoke punishment log for user: " + userId + " with type: " + typeId);
        }
        int row = this.userProvider.delete(userId, typeId);
        if (row < 1) {
            throw new PunishmentException("Failed to unpunished user: " + userId + " with type: " + typeId);
        }
        return row;
    }

    public int unpunishedIp(String ipAddress, int typeId, UUID logId, int changedBy) {
        PunishmentLog currentLog = this.logProvider.getLog(logId);
        if (currentLog == null) {
            throw new PunishmentException("Punishment log not found for IP: " + ipAddress + " with type: " + typeId);
        }
        PunishmentLog revokeLog = this.logProvider.revoke(null, ipAddress, currentLog, changedBy);
        if (revokeLog == null) {
            throw new PunishmentException("Failed to revoke punishment log for IP: " + ipAddress + " with type: " + typeId);
        }
        int row = this.ipProvider.delete(ipAddress, typeId);
        if (row < 1) {
            throw new PunishmentException("Failed to unpunished IP: " + ipAddress + " with type: " + typeId);
        }
        return row;
    }

    public void autoUnpunishedUser(int userId, int typeId) {
        this.userProvider.delete(userId, typeId);
    }

    public void autoUnpunishedIp(String ipAddress, int typeId) {
        this.ipProvider.delete(ipAddress, typeId);
    }

    public boolean isPunishedUser(int userId, int typeId) {
        return this.userProvider.getPunishedUser(userId, typeId) != null;
    }

    public boolean isPunishedIp(String ipAddress, int typeId) {
        return this.ipProvider.getPunishedIp(ipAddress, typeId) != null;
    }

    public boolean isExpiredUser(UUID logId) {
        PunishmentLog log = this.logProvider.getLog(logId);
        return log != null && log.isExpired();
    }

    public boolean isExpiredIp(UUID logId) {
        PunishmentLog log = this.logProvider.getLog(logId);
        return log != null && log.isExpired();
    }
}

