/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.language.message;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.library.utils.StringUtil;
import de.murmelmeister.murmelapi.language.message.Message;
import de.murmelmeister.murmelapi.language.message.MessageCache;
import de.murmelmeister.murmelapi.language.message.MessageProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public final class MessageProviderImpl
implements MessageProvider {
    private static final String TABLE_NAME = "messages";
    private final Database database;
    private final MessageCache cache;
    private final RefreshType all = RefreshType.MESSAGES;
    private final RefreshType single = RefreshType.SINGLE_MESSAGE;

    public MessageProviderImpl(Database database, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.cache = new MessageCache(database, TABLE_NAME, fetchLimit, cacheCapacity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id INT NOT NULL PRIMARY KEY AUTO_INCREMENT, tag_id VARCHAR(255) NOT NULL, language_id INT NOT NULL, UNIQUE (tag_id, language_id), message TEXT NOT NULL, FOREIGN KEY (language_id) REFERENCES languages(id) ON DELETE CASCADE");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public Message get(int messageId) {
        return this.cache.getById(messageId);
    }

    @Override
    public Message get(String tagId, int languageId) {
        return this.cache.getByTag(tagId, languageId);
    }

    @Override
    public List<Message> getAllMessages(int languageId) {
        return this.cache.getByLanguage(languageId);
    }

    @Override
    public Message create(String tagId, int languageId, String message) {
        String normalizedTagId = StringUtil.normalize(tagId);
        if (normalizedTagId == null || languageId < 1 || message == null || message.isBlank()) {
            return null;
        }
        String sql = "INSERT INTO messages (tag_id, language_id, message) VALUES (?, ?, ?)";
        int id = (int)this.database.updateAndGetGeneratedKeys(sql, stmt -> {
            stmt.setString(1, normalizedTagId);
            stmt.setInt(2, languageId);
            stmt.setString(3, message);
        });
        if (id < 1) {
            return null;
        }
        Message msg = new Message(id, normalizedTagId, languageId, message);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(msg.id()));
        return msg;
    }

    @Override
    public int delete(int id) {
        if (id < 1) {
            return 0;
        }
        String sql = "DELETE FROM messages WHERE id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, id));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(id));
        return row;
    }

    @Override
    public int delete(String tagId, int languageId) {
        String normalizedTagId = StringUtil.normalize(tagId);
        if (normalizedTagId == null || languageId < 1) {
            return 0;
        }
        String sql = "DELETE FROM messages WHERE tag_id = ? AND language_id = ?";
        int row = this.database.update(sql, stmt -> {
            stmt.setString(1, normalizedTagId);
            stmt.setInt(2, languageId);
        });
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, new MessageCache.TagKey(normalizedTagId, languageId));
        return row;
    }

    @Override
    public int deleteAll(int languageId) {
        if (languageId < 1) {
            return 0;
        }
        String sql = "DELETE FROM messages WHERE language_id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, languageId));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, new MessageCache.LanguageKey(languageId));
        return row;
    }

    @Override
    public Message update(int id, String tagId, int languageId, String message) {
        String normalizedTagId = StringUtil.normalize(tagId);
        if (id < 1 || normalizedTagId == null || languageId < 1 || message == null || message.isBlank()) {
            return null;
        }
        Message existing = this.cache.getById(id);
        if (existing == null) {
            return null;
        }
        if (Objects.equals(normalizedTagId, existing.tagId()) && languageId == existing.languageId() && Objects.equals(message, existing.message())) {
            return existing;
        }
        String sql = "UPDATE messages SET tag_id = ?, language_id = ?, message = ? WHERE id = ?";
        int rows = this.database.update(sql, stmt -> {
            stmt.setString(1, normalizedTagId);
            stmt.setInt(2, languageId);
            stmt.setString(3, message);
            stmt.setInt(4, id);
        });
        if (rows < 1) {
            return null;
        }
        Message msg = existing.withUpdateMeta(normalizedTagId, languageId, message);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(id));
        return msg;
    }

    @Override
    public int[] upsertAll(Properties properties) {
        return this.upsertInternal(properties, true);
    }

    @Override
    public int[] upsertAll(Collection<Properties> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Missing properties collection");
        }
        ArrayList<int[]> results = new ArrayList<int[]>();
        boolean changed = false;
        for (Properties props : properties) {
            int[] result = this.upsertInternal(props, false);
            if (result.length <= 0) continue;
            results.add(result);
            changed = true;
        }
        if (changed) {
            RefreshUtil.fireCache(this.all);
        }
        int total = results.stream().mapToInt(arr -> ((int[])arr).length).sum();
        int[] merged = new int[total];
        int offset = 0;
        for (int[] arr2 : results) {
            System.arraycopy(arr2, 0, merged, offset, arr2.length);
            offset += arr2.length;
        }
        return merged;
    }

    @Override
    public int[] createOrUpdateAll(Properties properties) {
        return this.upsertInternal(properties, true);
    }

    private int[] upsertInternal(Properties properties, boolean fireCache) {
        int languageId;
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Missing properties file");
        }
        String language = properties.getProperty("language.id");
        if (language == null || language.isBlank()) {
            throw new IllegalArgumentException("Missing language.id property");
        }
        try {
            languageId = Integer.parseInt(language);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid language.id property is not a integer", e);
        }
        String selectSql = "SELECT tag_id, message FROM messages WHERE language_id = ?";
        HashMap existing = new HashMap();
        this.database.queryList(selectSql, rs -> Map.entry(rs.getString(1), rs.getString(2)), stmt -> stmt.setInt(1, languageId)).forEach(entry -> existing.put((String)entry.getKey(), (String)entry.getValue()));
        String updateSql = "UPDATE messages SET message = ? WHERE tag_id = ? AND language_id = ?";
        int[] updated = this.database.updateBatch(updateSql, stmt -> {
            for (String tagId : properties.stringPropertyNames()) {
                String current;
                String msg;
                if (tagId.isBlank() || tagId.startsWith("#") || tagId.equals("language.id") || (msg = properties.getProperty(tagId)) == null || msg.isBlank() || (current = (String)existing.get(tagId)) == null || current.equals(msg)) continue;
                stmt.setString(1, msg);
                stmt.setString(2, tagId);
                stmt.setInt(3, languageId);
                stmt.addBatch();
            }
        });
        String insertSql = "INSERT INTO messages (tag_id, language_id, message) VALUES (?, ?, ?)";
        int[] inserted = this.database.updateBatch(insertSql, stmt -> {
            for (String tagId : properties.stringPropertyNames()) {
                String msg;
                if (tagId.isBlank() || tagId.startsWith("#") || tagId.equals("language.id") || (msg = properties.getProperty(tagId)) == null || msg.isBlank() || existing.containsKey(tagId)) continue;
                stmt.setString(1, tagId);
                stmt.setInt(2, languageId);
                stmt.setString(3, msg);
                stmt.addBatch();
            }
        });
        int totalOps = (updated == null ? 0 : updated.length) + (inserted == null ? 0 : inserted.length);
        if (fireCache && totalOps > 0) {
            RefreshUtil.fireCache(this.all);
        }
        int updateLen = updated == null ? 0 : updated.length;
        int insertLen = inserted == null ? 0 : inserted.length;
        int[] result = new int[updateLen + insertLen];
        if (updated != null) {
            System.arraycopy(updated, 0, result, 0, updateLen);
        }
        if (inserted != null) {
            System.arraycopy(inserted, 0, result, updateLen, insertLen);
        }
        return result;
    }
}

