/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.permission;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.library.utils.StringUtil;
import de.murmelmeister.murmelapi.group.permission.GroupPermission;
import de.murmelmeister.murmelapi.group.permission.GroupPermissionCache;
import de.murmelmeister.murmelapi.group.permission.GroupPermissionProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public final class GroupPermissionProviderImpl
implements GroupPermissionProvider {
    private static final String TABLE_NAME = "group_permission";
    private final Database database;
    private final GroupPermissionCache cache;
    private final RefreshType all = RefreshType.GROUP_PERMISSIONS;
    private final RefreshType single = RefreshType.SINGLE_GROUP_PERMISSION;

    public GroupPermissionProviderImpl(Database database, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.cache = new GroupPermissionCache(database, TABLE_NAME, fetchLimit, cacheCapcity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "group_id INT, permission VARCHAR(200), PRIMARY KEY (group_id, permission), expires_at DATETIME NULL, created_by INT NOT NULL, created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(), changed_by INT NULL, changed_at DATETIME NULL ON UPDATE CURRENT_TIMESTAMP(),FOREIGN KEY (group_id) REFERENCES groups(id), FOREIGN KEY (created_by) REFERENCES users(id), FOREIGN KEY (changed_by) REFERENCES users(id)");
        database.update("CREATE INDEX IF NOT EXISTS idx_group_perm_groupId_exp ON group_permission (group_id, expires_at)");
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public GroupPermission getPermission(int groupId, String permission) {
        return this.cache.get(groupId, permission);
    }

    @Override
    public List<GroupPermission> getPermissions(int groupId) {
        return this.cache.getPermissions(groupId);
    }

    @Override
    public GroupPermission add(int groupId, String permission, long duration, int createdBy) {
        String normalizedPermission = StringUtil.normalize(permission);
        if (groupId < 1 || normalizedPermission == null || duration < -1L || createdBy < -1) {
            return null;
        }
        String insertSql = "INSERT INTO group_permission (group_id, permission, expires_at, created_by) VALUES (?, ?, ?, ?)";
        LocalDateTime expiresAt = duration == -1L ? null : LocalDateTime.now().plusSeconds(duration);
        int row = this.database.update(insertSql, stmt -> {
            stmt.setInt(1, groupId);
            stmt.setString(2, normalizedPermission);
            stmt.setTimestamp(3, expiresAt == null ? null : Timestamp.valueOf(expiresAt));
            stmt.setInt(4, createdBy);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT created_at FROM group_permission WHERE group_id = ? AND permission = ?";
        LocalDateTime createdAt = this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("created_at").toLocalDateTime(), stmt -> {
            stmt.setInt(1, groupId);
            stmt.setString(2, normalizedPermission);
        });
        if (createdAt == null) {
            return null;
        }
        GroupPermission groupPermission = new GroupPermission(groupId, normalizedPermission, expiresAt, createdBy, createdAt, null, null);
        RefreshUtil.fireSingle(this.single, new GroupPermissionCache.PermissionKey(groupId, normalizedPermission));
        return groupPermission;
    }

    @Override
    public int remove(int groupId, String permission) {
        String normalizedPermission = StringUtil.normalize(permission);
        if (groupId < 1 || normalizedPermission == null) {
            return 0;
        }
        String sql = "DELETE FROM group_permission WHERE group_id = ? AND permission = ?";
        int row = this.database.update(sql, stmt -> {
            stmt.setInt(1, groupId);
            stmt.setString(2, normalizedPermission);
        });
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, new GroupPermissionCache.PermissionKey(groupId, normalizedPermission));
        return row;
    }

    @Override
    public int clear(int groupId) {
        if (groupId < 1) {
            return 0;
        }
        String sql = "DELETE FROM group_permission WHERE group_id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, groupId));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(groupId));
        return row;
    }

    @Override
    public GroupPermission update(int groupId, String permission, long duration, int changedBy) {
        String normalizedPermission = StringUtil.normalize(permission);
        if (groupId < 1 || normalizedPermission == null || duration < -1L || changedBy < -1) {
            return null;
        }
        LocalDateTime expiresAt = duration == -1L ? null : LocalDateTime.now().plusSeconds(duration);
        GroupPermission existing = this.cache.get(groupId, normalizedPermission);
        if (existing == null) {
            return null;
        }
        if (Objects.equals(expiresAt, existing.expiresAt())) {
            return existing;
        }
        String updateSql = "UPDATE group_permission SET expires_at = ?, changed_by = ? WHERE group_id = ? AND permission = ?";
        int row = this.database.update(updateSql, stmt -> {
            stmt.setString(1, expiresAt == null ? null : Timestamp.valueOf(expiresAt).toString());
            stmt.setInt(2, changedBy);
            stmt.setInt(3, groupId);
            stmt.setString(4, normalizedPermission);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT changed_at FROM group_permission WHERE group_id = ? AND permission = ?";
        LocalDateTime changedAt = this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("changed_at").toLocalDateTime(), stmt -> {
            stmt.setInt(1, groupId);
            stmt.setString(2, normalizedPermission);
        });
        if (changedAt == null) {
            return null;
        }
        GroupPermission groupPermission = existing.withUpdateMeta(expiresAt, changedBy, changedAt);
        RefreshUtil.fireSingle(this.single, new GroupPermissionCache.PermissionKey(groupId, normalizedPermission));
        return groupPermission;
    }

    @Override
    public int loadExpired() {
        List<GroupPermissionCache.PermissionKey> expiredPermissions = this.cache.getCachedPermissions().stream().filter(GroupPermission::isExpired).map(permission -> new GroupPermissionCache.PermissionKey(permission.groupId(), permission.permission())).toList();
        if (expiredPermissions.isEmpty()) {
            return 0;
        }
        String sql = "DELETE FROM group_permission WHERE expires_at IS NOT NULL AND expires_at <= CURRENT_TIMESTAMP()";
        int removed = this.database.update(sql);
        expiredPermissions.forEach(key -> RefreshUtil.fireSingle(this.single, key));
        return removed;
    }
}

