/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.parent;

import com.github.benmanes.caffeine.cache.LoadingCache;
import de.murmelmeister.library.database.Database;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.utils.CacheUtil;
import de.murmelmeister.murmelapi.utils.ResultSetUtil;
import de.murmelmeister.murmelapi.utils.update.RefreshEvent;
import de.murmelmeister.murmelapi.utils.update.RefreshListener;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupParentCache
implements RefreshListener,
AutoCloseable {
    private static final String ALL_KEY = "ALL";
    private static final Pattern KEY_PATTERN = Pattern.compile(".*groupId=(\\d+), parentId=(\\d+).*");
    private final Database database;
    private final String tableName;
    private final LoadingCache<ParentKey, GroupParent> cacheByKey;
    private final LoadingCache<Integer, List<GroupParent>> cacheByGroupId;
    private final LoadingCache<String, List<GroupParent>> listCache;
    private final Long fetchLimit;

    public GroupParentCache(Database database, String tableName, Long fetchLimit, long cacheCapacity, Duration refreshInterval) {
        this.database = database;
        this.tableName = tableName;
        this.fetchLimit = fetchLimit;
        this.cacheByKey = CacheUtil.buildCacheRefresh(this::loadByKey, cacheCapacity, refreshInterval);
        this.cacheByGroupId = CacheUtil.buildCacheRefresh(this::loadByGroupId, cacheCapacity, refreshInterval);
        this.listCache = CacheUtil.buildCacheRefresh(key -> this.loadAllFromDatabase(), 1L, refreshInterval);
        RefreshUtil.register(this);
    }

    @Override
    public void onRefresh(RefreshEvent<?> event) {
        String cacheName = event.type();
        if (RefreshType.GROUP_PARENTS.getName().equalsIgnoreCase(cacheName) || RefreshType.ALL.getName().equalsIgnoreCase(cacheName)) {
            this.refreshAll();
        } else if (RefreshType.SINGLE_GROUP_PARENT.getName().equalsIgnoreCase(cacheName)) {
            Object key = event.key();
            if (!(key instanceof String)) {
                if (key instanceof ParentKey) {
                    ParentKey parentKey = (ParentKey)key;
                    this.refreshSingle(parentKey);
                } else if (key instanceof Integer) {
                    Integer groupId = (Integer)key;
                    this.refreshSingle(groupId);
                }
            } else {
                Matcher matcher = KEY_PATTERN.matcher((String)key);
                if (matcher.matches()) {
                    int groupId = Integer.parseInt(matcher.group(1));
                    int parentId = Integer.parseInt(matcher.group(2));
                    this.refreshSingle(new ParentKey(groupId, parentId));
                } else {
                    int groupId = Integer.parseInt((String)key);
                    this.refreshSingle(groupId);
                }
            }
        }
    }

    @Override
    public void close() {
        RefreshUtil.unregister(this);
        this.clear();
    }

    private void refreshAll() {
        this.clear();
        List<GroupParent> parents = this.loadAllFromDatabase();
        if (parents.isEmpty()) {
            return;
        }
        HashMap<Integer, List> byGroup = new HashMap<Integer, List>();
        for (GroupParent parent : parents) {
            ParentKey key = new ParentKey(parent.groupId(), parent.parentId());
            this.cacheByKey.put(key, parent);
            byGroup.computeIfAbsent(parent.groupId(), ignored -> new ArrayList()).add(parent);
        }
        byGroup.forEach((groupId, values) -> this.cacheByGroupId.put((Integer)groupId, List.copyOf(values)));
        this.listCache.put(ALL_KEY, List.copyOf(parents));
    }

    private void refreshSingle(int groupId) {
        this.remove(groupId);
        List<GroupParent> parents = this.loadByGroupId(groupId);
        parents.forEach(this::put);
    }

    private void refreshSingle(ParentKey key) {
        this.remove(key.groupId(), key.parentId());
        GroupParent groupParent = this.loadByKey(key);
        if (groupParent != null) {
            this.put(groupParent);
        }
    }

    public List<GroupParent> loadAllFromDatabase() {
        String sql = "SELECT * FROM " + this.tableName;
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.groupParent());
    }

    public List<GroupParent> loadByGroupId(int groupId) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE group_id = ?";
        return CacheUtil.loadList(this.database, sql, this.fetchLimit, ResultSetUtil.groupParent(), stmt -> stmt.setInt(1, groupId));
    }

    private GroupParent loadByKey(ParentKey key) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE group_id = ? AND parent_id = ?";
        return CacheUtil.loadSingle(this.database, sql, this.fetchLimit, ResultSetUtil.groupParent(), stmt -> {
            stmt.setInt(1, key.groupId());
            stmt.setInt(2, key.parentId());
        });
    }

    public GroupParent get(int groupId, int parentId) {
        return this.cacheByKey.get(new ParentKey(groupId, parentId));
    }

    public List<GroupParent> getParents(int groupId) {
        return this.cacheByGroupId.get(groupId);
    }

    public void put(GroupParent groupParent) {
        ParentKey key = new ParentKey(groupParent.groupId(), groupParent.parentId());
        this.cacheByKey.put(key, groupParent);
        CacheUtil.put(this.cacheByGroupId, groupParent.groupId(), groupParent, v -> v.groupId() == groupParent.groupId() && v.parentId() == groupParent.parentId());
        CacheUtil.put(this.listCache, ALL_KEY, groupParent, v -> v.groupId() == groupParent.groupId() && v.parentId() == groupParent.parentId());
    }

    public void remove(int groupId, int parentId) {
        ParentKey key = new ParentKey(groupId, parentId);
        this.cacheByKey.invalidate(key);
        CacheUtil.remove(this.cacheByGroupId, groupId, v -> v.groupId() == groupId && v.parentId() == parentId);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.groupId() == groupId && v.parentId() == parentId);
    }

    public void remove(int groupId) {
        this.cacheByKey.asMap().keySet().stream().filter(key -> key.groupId() == groupId).forEach(this.cacheByKey::invalidate);
        this.cacheByGroupId.invalidate(groupId);
        CacheUtil.remove(this.listCache, ALL_KEY, v -> v.groupId() == groupId);
    }

    public void clear() {
        this.cacheByKey.invalidateAll();
        this.cacheByGroupId.invalidateAll();
        this.listCache.invalidateAll();
    }

    public List<GroupParent> getCachedParents() {
        List<GroupParent> parents = this.listCache.get(ALL_KEY);
        if (parents == null || parents.isEmpty()) {
            return Collections.emptyList();
        }
        return List.copyOf(parents);
    }

    protected record ParentKey(int groupId, int parentId) {
    }
}

