/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group;

import de.murmelmeister.library.database.Database;
import de.murmelmeister.library.utils.StringUtil;
import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.GroupCache;
import de.murmelmeister.murmelapi.group.GroupProvider;
import de.murmelmeister.murmelapi.utils.update.RefreshType;
import de.murmelmeister.murmelapi.utils.update.RefreshUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class GroupProviderImpl
implements GroupProvider {
    private static final String TABLE_NAME = "groups";
    private final Database database;
    private final GroupCache cache;
    private final RefreshType all = RefreshType.GROUPS;
    private final RefreshType single = RefreshType.SINGLE_GROUP;

    public GroupProviderImpl(Database database, Long fetchLimit, long cacheCapcity, Duration refreshInterval) {
        this.database = database;
        this.cache = new GroupCache(database, TABLE_NAME, fetchLimit, cacheCapcity, refreshInterval);
    }

    public static void setup(Database database) {
        database.createTable(TABLE_NAME, "id INT PRIMARY KEY AUTO_INCREMENT, group_name VARCHAR(100) NOT NULL UNIQUE, priority INT NOT NULL DEFAULT 0, is_default BOOLEAN NOT NULL DEFAULT FALSE, created_by INT NOT NULL, created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP(), changed_by INT NULL, changed_at DATETIME NULL ON UPDATE CURRENT_TIMESTAMP(), FOREIGN KEY (created_by) REFERENCES users(id), FOREIGN KEY (changed_by) REFERENCES users(id)");
    }

    public static void createDefaultGroup(Database database) {
        String sql = "INSERT IGNORE INTO groups (id, group_name, priority, is_default, created_by) VALUES (?, ?, ?, ?, ?)";
        database.update(sql, stmt -> {
            stmt.setInt(1, 1);
            stmt.setString(2, "default");
            stmt.setInt(3, 1);
            stmt.setBoolean(4, true);
            stmt.setInt(5, -1);
        });
    }

    @Override
    public void closeCache() {
        this.cache.close();
    }

    @Override
    public void refreshCache() {
        RefreshUtil.fireCache(this.all);
    }

    @Override
    public Group findById(int id) {
        return this.cache.getById(id);
    }

    @Override
    public Group findByName(String groupName) {
        return this.cache.getByName(groupName);
    }

    @Override
    public List<Group> findAll() {
        return this.cache.getCachedGroups();
    }

    @Override
    public List<String> findAllGroupNames() {
        return this.findAll().stream().map(Group::groupName).collect(Collectors.toList());
    }

    @Override
    public Group create(String groupName, int priority, int createdBy) {
        String normalizedGroupName = StringUtil.normalize(groupName);
        if (normalizedGroupName == null || priority < 0 || createdBy < -1) {
            return null;
        }
        String insertSql = "INSERT INTO groups (group_name, priority, created_by) VALUES (?, ?, ?)";
        int groupId = (int)this.database.updateAndGetGeneratedKeys(insertSql, stmt -> {
            stmt.setString(1, normalizedGroupName);
            stmt.setInt(2, priority);
            stmt.setInt(3, createdBy);
        });
        if (groupId < 1) {
            return null;
        }
        String selectSql = "SELECT created_at FROM groups WHERE id = ?";
        LocalDateTime createdAt = this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("created_at").toLocalDateTime(), stmt -> stmt.setInt(1, groupId));
        if (createdAt == null) {
            return null;
        }
        Group group = new Group(groupId, normalizedGroupName, priority, false, createdBy, createdAt, null, null);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(groupId));
        return group;
    }

    @Override
    public int delete(int groupId) {
        if (groupId < 1) {
            return 0;
        }
        String sql = "DELETE FROM groups WHERE id = ?";
        int row = this.database.update(sql, stmt -> stmt.setInt(1, groupId));
        if (row < 1) {
            return 0;
        }
        RefreshUtil.fireSingle(this.single, Integer.valueOf(groupId));
        return row;
    }

    @Override
    public Group update(int groupId, String groupName, int priority, int changedBy) {
        String normalizedGroupName = StringUtil.normalize(groupName);
        if (normalizedGroupName == null || priority < 0 || changedBy < -1) {
            return null;
        }
        Group existing = this.cache.getById(groupId);
        if (existing == null) {
            return null;
        }
        if (Objects.equals(normalizedGroupName, existing.groupName()) && priority == existing.priority()) {
            return existing;
        }
        String updateSql = "UPDATE groups SET group_name = ?, priority = ?, changed_by = ? WHERE id = ?";
        int row = this.database.update(updateSql, stmt -> {
            stmt.setString(1, normalizedGroupName);
            stmt.setInt(2, priority);
            stmt.setInt(3, changedBy);
            stmt.setInt(4, groupId);
        });
        if (row < 1) {
            return null;
        }
        String selectSql = "SELECT changed_at FROM groups WHERE id = ?";
        LocalDateTime changedAt = this.database.query(selectSql, null, resultSet -> resultSet.getTimestamp("changed_at").toLocalDateTime(), stmt -> stmt.setInt(1, groupId));
        if (changedAt == null) {
            return null;
        }
        Group group = existing.withUpdateMeta(normalizedGroupName, priority, changedBy, changedAt);
        RefreshUtil.fireSingle(this.single, Integer.valueOf(groupId));
        return group;
    }
}

