/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.library.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

@FunctionalInterface
public interface ParameterProcessor {
    public static final ParameterProcessor NO_OP = statement -> {};

    public void execute(PreparedStatement var1) throws SQLException;

    public static ParameterProcessor noop() {
        return NO_OP;
    }

    public static ParameterProcessor of(ParameterProcessor processor) {
        return processor == null ? ParameterProcessor.noop() : processor;
    }

    default public ParameterProcessor andThen(ParameterProcessor after) {
        ParameterProcessor next = ParameterProcessor.of(after);
        return statement -> {
            this.execute(statement);
            next.execute(statement);
        };
    }

    default public ParameterProcessor compose(ParameterProcessor before) {
        ParameterProcessor previous = ParameterProcessor.of(before);
        return statement -> {
            previous.execute(statement);
            this.execute(statement);
        };
    }

    public static ParameterProcessor combine(ParameterProcessor ... processors) {
        Objects.requireNonNull(processors, "processors");
        ParameterProcessor result = ParameterProcessor.noop();
        for (ParameterProcessor processor : processors) {
            result = result.andThen(processor);
        }
        return result;
    }
}

