/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import com.zaxxer.hikari.HikariDataSource;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class Database {
    private static final HikariDataSource DATA_SOURCE = new HikariDataSource();
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock(true);
    private static final Lock READ_LOCK = LOCK.readLock();
    private static final Lock WRITE_LOCK = LOCK.writeLock();

    public static void connect(String url, String user, String password) {
        WRITE_LOCK.lock();
        try {
            DATA_SOURCE.setJdbcUrl(url);
            DATA_SOURCE.setUsername(user);
            DATA_SOURCE.setPassword(password);
        }
        catch (Exception e) {
            throw new RuntimeException("Database connecting error", e);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static void connectEnv(String url, String user, String password) {
        Database.connect(System.getenv(url), System.getenv(user), System.getenv(password));
    }

    public static void connect(String driver, String hostname, String port, String database, String username, String password) {
        Database.connect(String.format("jdbc:%s://%s:%s/%s", driver, hostname, port, database), username, password);
    }

    public static void connectEnv(String driver, String hostname, String port, String database, String username, String password) {
        Database.connect(System.getenv(driver), System.getenv(hostname), System.getenv(port), System.getenv(database), System.getenv(username), System.getenv(password));
    }

    public static void disconnect() {
        WRITE_LOCK.lock();
        try {
            if (!DATA_SOURCE.isClosed()) {
                DATA_SOURCE.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Database closing error", e);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static void update(String sql, Object ... objects) {
        WRITE_LOCK.lock();
        try (Connection connection = DATA_SOURCE.getConnection();
             PreparedStatement statement = Database.getPreparedStatement(connection, sql, objects);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Database updating error", e);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static void callUpdate(String name, Object ... objects) {
        WRITE_LOCK.lock();
        try (Connection connection = DATA_SOURCE.getConnection();
             CallableStatement statement = Database.getCallableStatement(connection, name, objects);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Database calling update error", e);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T callUpdate(T defaultValue, String label, Class<T> type, String name, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void createTable(String tableName, String value) {
        Database.update("CREATE TABLE IF NOT EXISTS [TABLE] ([VALUES])".replace("[TABLE]", tableName).replace("[VALUES]", value), new Object[0]);
    }

    /*
     * Exception decompiling
     */
    public static <T> T query(T defaultValue, String label, Class<T> type, String sql, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> queryList(String label, Class<T> type, String sql, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> T callQuery(T defaultValue, String label, Class<T> type, String name, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> List<T> callQueryList(String label, Class<T> type, String name, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean exists(String sql, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean callExists(String name, Object ... objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getProcedureQuery(String name, String input, String query, Object ... objects) {
        return String.format("CREATE PROCEDURE IF NOT EXISTS %s(%s)\nBEGIN\n    %s\nEND;", name, input, String.format(query, objects));
    }

    public static String getProcedureQueryWithoutObjects(String name, String input, String query) {
        return "CREATE PROCEDURE IF NOT EXISTS " + name + "(" + input + ")\nBEGIN\n    " + query + "\nEND;";
    }

    private static String getQueryWithCall(String name, Object ... objects) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append("'").append(objects[i]).append("'");
        }
        return "CALL " + name + "(" + String.valueOf(builder) + ")";
    }

    private static CallableStatement getCallableStatement(Connection connection, String name, Object ... objects) throws SQLException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append("?");
        }
        CallableStatement statement = connection.prepareCall("{CALL " + name + "(" + String.valueOf(builder) + ")}");
        Database.setParameters(statement, objects);
        return statement;
    }

    private static PreparedStatement getPreparedStatement(Connection connection, String query, Object ... objects) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(query);
        Database.setParameters(statement, objects);
        return statement;
    }

    private static void setParameters(PreparedStatement statement, Object ... objects) throws SQLException {
        block23: for (int i = 0; i < objects.length; ++i) {
            Object object;
            Object object2 = object = objects[i];
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, String.class, byte[].class, Date.class, Time.class, Timestamp.class, Ref.class, Blob.class, Clob.class, Array.class, URL.class, RowId.class, SQLXML.class, UUID.class}, (Object)object2, n)) {
                case 0: {
                    Boolean value = (Boolean)object2;
                    statement.setBoolean(i + 1, value);
                    continue block23;
                }
                case 1: {
                    Byte value = (Byte)object2;
                    statement.setByte(i + 1, value);
                    continue block23;
                }
                case 2: {
                    Short value = (Short)object2;
                    statement.setShort(i + 1, value);
                    continue block23;
                }
                case 3: {
                    Integer value = (Integer)object2;
                    statement.setInt(i + 1, value);
                    continue block23;
                }
                case 4: {
                    Long value = (Long)object2;
                    statement.setLong(i + 1, value);
                    continue block23;
                }
                case 5: {
                    Float value = (Float)object2;
                    statement.setFloat(i + 1, value.floatValue());
                    continue block23;
                }
                case 6: {
                    Double value = (Double)object2;
                    statement.setDouble(i + 1, value);
                    continue block23;
                }
                case 7: {
                    BigDecimal value = (BigDecimal)object2;
                    statement.setBigDecimal(i + 1, value);
                    continue block23;
                }
                case 8: {
                    String value = (String)object2;
                    statement.setString(i + 1, value);
                    continue block23;
                }
                case 9: {
                    byte[] value = (byte[])object2;
                    statement.setBytes(i + 1, value);
                    continue block23;
                }
                case 10: {
                    Date value = (Date)object2;
                    statement.setDate(i + 1, value);
                    continue block23;
                }
                case 11: {
                    Time value = (Time)object2;
                    statement.setTime(i + 1, value);
                    continue block23;
                }
                case 12: {
                    Timestamp value = (Timestamp)object2;
                    statement.setTimestamp(i + 1, value);
                    continue block23;
                }
                case 13: {
                    Ref value = (Ref)object2;
                    statement.setRef(i + 1, value);
                    continue block23;
                }
                case 14: {
                    Blob value = (Blob)object2;
                    statement.setBlob(i + 1, value);
                    continue block23;
                }
                case 15: {
                    Clob value = (Clob)object2;
                    statement.setClob(i + 1, value);
                    continue block23;
                }
                case 16: {
                    Array value = (Array)object2;
                    statement.setArray(i + 1, value);
                    continue block23;
                }
                case 17: {
                    URL value = (URL)object2;
                    statement.setURL(i + 1, value);
                    continue block23;
                }
                case 18: {
                    RowId value = (RowId)object2;
                    statement.setRowId(i + 1, value);
                    continue block23;
                }
                case 19: {
                    SQLXML value = (SQLXML)object2;
                    statement.setSQLXML(i + 1, value);
                    continue block23;
                }
                case 20: {
                    UUID value = (UUID)object2;
                    statement.setString(i + 1, value.toString());
                    continue block23;
                }
                default: {
                    statement.setObject(i + 1, object);
                }
            }
        }
    }
}

