/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.user.settings;

import de.murmelmeister.murmelapi.user.User;
import de.murmelmeister.murmelapi.user.settings.UserSettings;
import de.murmelmeister.murmelapi.utils.Database;
import java.text.SimpleDateFormat;

public final class UserSettingsProvider
implements UserSettings {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public UserSettingsProvider(User user) {
        String tableName = "UserSettings";
        this.createTable(tableName);
        Procedure.loadAll(tableName);
        this.loadTablesIfNotCreated(user);
    }

    private void createTable(String tableName) {
        Database.createTable(tableName, "ID INT PRIMARY KEY, FirstJoin BIGINT, LastQuit BIGINT, Online BOOL");
    }

    @Override
    public boolean existsUser(int id) {
        return Database.callExists(Procedure.USER_SETTINGS_ID.getName(), id);
    }

    @Override
    public void createUser(int id) {
        if (this.existsUser(id)) {
            return;
        }
        Database.callUpdate(Procedure.USER_SETTINGS_INSERT.getName(), id, System.currentTimeMillis(), System.currentTimeMillis(), 0);
    }

    @Override
    public void deleteUser(int id) {
        Database.callUpdate(Procedure.USER_SETTINGS_DELETE.getName(), id);
    }

    @Override
    public long getFirstJoinTime(int id) {
        return Database.callQuery(-1L, "FirstJoin", Long.TYPE, Procedure.USER_SETTINGS_ID.getName(), id);
    }

    @Override
    public String getFirstJoinDate(int id) {
        return this.dateFormat.format(this.getFirstJoinTime(id));
    }

    @Override
    public long getLstQuitTime(int id) {
        return Database.callQuery(-1L, "LastQuit", Long.TYPE, Procedure.USER_SETTINGS_ID.getName(), id);
    }

    @Override
    public void setLastQuitTime(int id, long time) {
        Database.callUpdate(Procedure.USER_SETTINGS_UPDATE_LAST_QUIT.getName(), id, time);
    }

    @Override
    public String getLastQuitDate(int id) {
        return this.dateFormat.format(this.getLstQuitTime(id));
    }

    @Override
    public void setOnline(int id, boolean isOnline) {
        Database.callUpdate(Procedure.USER_SETTINGS_UPDATE_ONLINE.getName(), id, isOnline ? (byte)1 : 0);
    }

    @Override
    public boolean isOnline(int id) {
        return Database.callQuery((byte)0, "Online", Byte.TYPE, Procedure.USER_SETTINGS_ID.getName(), id) == 1;
    }

    private void loadTablesIfNotCreated(User user) {
        for (int userId : user.getIds()) {
            this.createUser(userId);
        }
    }

    private static enum Procedure {
        USER_SETTINGS_ID("UserSettings_ID", "uid INT", "SELECT * FROM [TABLE] WHERE ID=uid;"),
        USER_SETTINGS_INSERT("UserSettings_Insert", "uid INT, first BIGINT, last BIGINT, isOnline BOOL", "INSERT INTO [TABLE] VALUES (uid, first, last, isOnline);"),
        USER_SETTINGS_DELETE("UserSettings_Delete", "uid INT", "DELETE FROM [TABLE] WHERE ID=uid;"),
        USER_SETTINGS_UPDATE_LAST_QUIT("UserSettings_UpdateLastQuit", "uid INT, last BIGINT", "UPDATE [TABLE] SET LastQuit=last WHERE ID=uid;"),
        USER_SETTINGS_UPDATE_ONLINE("UserSettings_UpdateOnline", "uid INT, isOnline BOOL", "UPDATE [TABLE] SET Online=isOnline WHERE ID=uid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQueryWithoutObjects(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery(String tableName) {
            return this.query.replace("[TABLE]", tableName);
        }

        public static void loadAll(String tableName) {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(tableName), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

