/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.permission;

import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.group.permission.GroupPermission;
import de.murmelmeister.murmelapi.utils.Database;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class GroupPermissionProvider
implements GroupPermission {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public GroupPermissionProvider() {
        String tableName = "GroupPermission";
        this.createTable(tableName);
        Procedure.loadAll(tableName);
    }

    private void createTable(String tableName) {
        Database.createTable(tableName, "GroupID INT, CreatorID INT, Permission VARCHAR(1000), CreatedTime BIGINT, ExpiredTime BIGINT");
    }

    @Override
    public boolean existsPermission(int groupId, String permission) {
        return Database.callExists(Procedure.GROUP_PERMISSION_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public void addPermission(int groupId, int creatorId, String permission, long time) {
        if (this.existsPermission(groupId, permission)) {
            return;
        }
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.callUpdate(Procedure.GROUP_PERMISSION_ADD.getName(), groupId, creatorId, permission, System.currentTimeMillis(), expired);
    }

    @Override
    public void removePermission(int groupId, String permission) {
        Database.callUpdate(Procedure.GROUP_PERMISSION_REMOVE.getName(), groupId, permission);
    }

    @Override
    public void clearPermission(int groupId) {
        Database.callUpdate(Procedure.GROUP_PERMISSION_CLEAR.getName(), groupId);
    }

    @Override
    public List<String> getPermissions(int groupId) {
        return Database.callQueryList("Permission", String.class, Procedure.GROUP_PERMISSION_GROUP_ID.getName(), groupId);
    }

    @Override
    public List<String> getAllPermissions(GroupParent groupParent, int groupId) {
        Set<String> permissions = Collections.synchronizedSet(new LinkedHashSet<String>(this.getPermissions(groupId)));
        groupParent.getParentIds(groupId).parallelStream().map(parentId -> this.getAllPermissions(groupParent, (int)parentId)).forEach(permissions::addAll);
        return new ArrayList<String>(permissions);
    }

    @Override
    public int getCreatorId(int groupId, String permission) {
        return Database.callQuery(-2, "CreatorID", Integer.TYPE, Procedure.GROUP_PERMISSION_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public long getCreatedTime(int groupId, String permission) {
        return Database.callQuery(-1L, "CreatedTime", Long.TYPE, Procedure.GROUP_PERMISSION_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public String getCreatedDate(int groupId, String permission) {
        return this.dateFormat.format(this.getCreatedTime(groupId, permission));
    }

    @Override
    public long getExpiredTime(int groupId, String permission) {
        return Database.callQuery(-2L, "ExpiredTime", Long.TYPE, Procedure.GROUP_PERMISSION_PERMISSION.getName(), groupId, permission);
    }

    @Override
    public String getExpiredDate(int groupId, String permission) {
        long time = this.getExpiredTime(groupId, permission);
        return time == -1L ? "never" : this.dateFormat.format(time);
    }

    @Override
    public String setExpiredTime(int groupId, String permission, long time) {
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.callUpdate(Procedure.GROUP_PERMISSION_EXPIRED.getName(), groupId, permission, expired);
        return this.getExpiredDate(groupId, permission);
    }

    @Override
    public String addExpiredTime(int groupId, String permission, long time) {
        long current = this.getExpiredTime(groupId, permission);
        long expired = current == -1L ? System.currentTimeMillis() + time : current + time;
        Database.callUpdate(Procedure.GROUP_PERMISSION_EXPIRED.getName(), groupId, permission, expired);
        return this.getExpiredDate(groupId, permission);
    }

    @Override
    public String removeExpiredTime(int groupId, String permission, long time) {
        long current = this.getExpiredTime(groupId, permission);
        long expired = current == -1L ? System.currentTimeMillis() : current - time;
        Database.callUpdate(Procedure.GROUP_PERMISSION_EXPIRED.getName(), groupId, permission, expired);
        return this.getExpiredDate(groupId, permission);
    }

    @Override
    public void loadExpired(Group group) {
        for (int groupId : group.getUniqueIds()) {
            for (String permission : this.getPermissions(groupId)) {
                long time = this.getExpiredTime(groupId, permission);
                if (time == -1L || time > System.currentTimeMillis()) continue;
                this.removePermission(groupId, permission);
            }
        }
    }

    private static enum Procedure {
        GROUP_PERMISSION_GROUP_ID("GroupPermission_GroupID", "gid INT", "SELECT * FROM [TABLE] WHERE GroupID=gid;"),
        GROUP_PERMISSION_PERMISSION("GroupPermission_Permission", "gid INT, perm VARCHAR(1000)", "SELECT * FROM [TABLE] WHERE GroupID=gid AND Permission=perm;"),
        GROUP_PERMISSION_ADD("GroupPermission_Add", "gid INT, creator INT, perm VARCHAR(1000), created BIGINT, expired BIGINT", "INSERT INTO [TABLE] VALUES (gid, creator, perm, created, expired);"),
        GROUP_PERMISSION_REMOVE("GroupPermission_Remove", "gid INT, perm VARCHAR(1000)", "DELETE FROM [TABLE] WHERE GroupID=gid AND Permission=perm;"),
        GROUP_PERMISSION_CLEAR("GroupPermission_Clear", "gid INT", "DELETE FROM [TABLE] WHERE GroupID=gid;"),
        GROUP_PERMISSION_EXPIRED("GroupPermission_Expired", "gid INT, perm VARCHAR(1000), expired BIGINT", "UPDATE [TABLE] SET ExpiredTime=expired WHERE GroupID=gid AND Permission=perm;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQueryWithoutObjects(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery(String tableName) {
            return this.query.replace("[TABLE]", tableName);
        }

        public static void loadAll(String tableName) {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(tableName), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

