/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.parent;

import de.murmelmeister.murmelapi.group.Group;
import de.murmelmeister.murmelapi.group.parent.GroupParent;
import de.murmelmeister.murmelapi.utils.Database;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;

public final class GroupParentProvider
implements GroupParent {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public GroupParentProvider() {
        String tableName = "GroupParent";
        this.createTable(tableName);
        Procedure.loadAll(tableName);
    }

    private void createTable(String tableName) {
        Database.createTable(tableName, "GroupID INT, CreatorID INT, ParentID INT, CreatedTime BIGINT(255), ExpiredTime BIGINT(255)");
    }

    @Override
    public boolean existsParent(int groupId, int parentId) {
        return Database.callExists(Procedure.GROUP_PARENT_PARENT.getName(), groupId, parentId);
    }

    @Override
    public void addParent(int groupId, int creatorId, int parentId, long time) {
        if (this.existsParent(groupId, parentId)) {
            return;
        }
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.callUpdate(Procedure.GROUP_PARENT_ADD.getName(), groupId, creatorId, parentId, System.currentTimeMillis(), expired);
    }

    @Override
    public void removeParent(int groupId, int parentId) {
        Database.callUpdate(Procedure.GROUP_PARENT_REMOVE.getName(), groupId, parentId);
    }

    @Override
    public void clearParent(int groupId) {
        Database.callUpdate(Procedure.GROUP_PARENT_CLEAR.getName(), groupId);
    }

    @Override
    public List<Integer> getParentIds(int groupId) {
        return Database.callQueryList("ParentID", Integer.TYPE, Procedure.GROUP_PARENT_GROUP_ID.getName(), groupId);
    }

    @Override
    public List<String> getParentNames(Group group, int groupId) {
        return this.getParentIds(groupId).parallelStream().map(group::getName).collect(Collectors.toList());
    }

    @Override
    public int getCreatorId(int groupId, int parentId) {
        return Database.callQuery(-2, "CreatorID", Integer.TYPE, Procedure.GROUP_PARENT_PARENT.getName(), groupId, parentId);
    }

    @Override
    public long getCreatedTime(int groupId, int parentId) {
        return Database.callQuery(-1L, "CreatedTime", Long.TYPE, Procedure.GROUP_PARENT_PARENT.getName(), groupId, parentId);
    }

    @Override
    public String getCreatedDate(int groupId, int parentId) {
        return this.dateFormat.format(this.getCreatedTime(groupId, parentId));
    }

    @Override
    public long getExpiredTime(int groupId, int parentId) {
        return Database.callQuery(-2L, "ExpiredTime", Long.TYPE, Procedure.GROUP_PARENT_PARENT.getName(), groupId, parentId);
    }

    @Override
    public String getExpiredDate(int groupId, int parentId) {
        long time = this.getExpiredTime(groupId, parentId);
        return time == -1L ? "never" : this.dateFormat.format(time);
    }

    @Override
    public String setExpiredTime(int groupId, int parentId, long time) {
        long expired = time == -1L ? time : System.currentTimeMillis() + time;
        Database.callUpdate(Procedure.GROUP_PARENT_EXPIRED.getName(), groupId, parentId, expired);
        return this.getExpiredDate(groupId, parentId);
    }

    @Override
    public String addExpiredTime(int groupId, int parentId, long time) {
        long current = this.getExpiredTime(groupId, parentId);
        long expired = current == -1L ? System.currentTimeMillis() + time : current + time;
        Database.callUpdate(Procedure.GROUP_PARENT_EXPIRED.getName(), groupId, parentId, expired);
        return this.getExpiredDate(groupId, parentId);
    }

    @Override
    public String removeExpiredTime(int groupId, int parentId, long time) {
        long current = this.getExpiredTime(groupId, parentId);
        long expired = current == -1L ? System.currentTimeMillis() : current - time;
        Database.callUpdate(Procedure.GROUP_PARENT_EXPIRED.getName(), groupId, parentId, expired);
        return this.getExpiredDate(groupId, parentId);
    }

    @Override
    public void loadExpired(Group group) {
        for (int groupId : group.getUniqueIds()) {
            for (int parentId : this.getParentIds(groupId)) {
                long time = this.getExpiredTime(groupId, parentId);
                if (time == -1L || time > System.currentTimeMillis()) continue;
                this.removeParent(groupId, parentId);
            }
        }
    }

    private static enum Procedure {
        GROUP_PARENT_GROUP_ID("GroupParent_GroupID", "gid INT", "SELECT * FROM [TABLE] WHERE GroupID=gid;"),
        GROUP_PARENT_PARENT("GroupParent_Parent", "gid INT, pid INT", "SELECT * FROM [TABLE] WHERE GroupID=gid AND ParentID=pid;"),
        GROUP_PARENT_ADD("GroupParent_Add", "gid INT, creator INT, pid INT, created BIGINT(255), expired BIGINT(255)", "INSERT INTO [TABLE] VALUES (gid, creator, pid, created, expired);"),
        GROUP_PARENT_REMOVE("GroupParent_Remove", "gid INT, pid INT", "DELETE FROM [TABLE] WHERE GroupID=gid AND ParentID=pid;"),
        GROUP_PARENT_CLEAR("GroupParent_Clear", "gid INT", "DELETE FROM [TABLE] WHERE GroupID=gid;"),
        GROUP_PARENT_EXPIRED("GroupParent_Expired", "gid INT, pid INT, expired BIGINT(255)", "UPDATE [TABLE] SET ExpiredTime=expired WHERE GroupID=gid AND ParentID=pid;");

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query) {
            this.name = name;
            this.query = Database.getProcedureQueryWithoutObjects(name, input, query);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery(String tableName) {
            return this.query.replace("[TABLE]", tableName);
        }

        public static void loadAll(String tableName) {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(tableName), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

