/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.configuration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class MurmelMemory {
    protected final Map<String, Object> data = new LinkedHashMap<String, Object>();

    public void set(String key, Object value) {
        this.data.put(key, value);
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public <T> Optional<T> getOptional(String key, Class<T> type) {
        Object value = this.data.get(key);
        if (type.isInstance(value)) {
            return Optional.of(type.cast(value));
        }
        return Optional.empty();
    }

    public <T> T get(String key, Class<T> type) {
        Object value = this.data.get(key);
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Byte getByte(String key) {
        return this.get(key, Byte.class);
    }

    public Short getShort(String key) {
        return this.get(key, Short.class);
    }

    public Integer getInteger(String key) {
        return this.get(key, Integer.class);
    }

    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    public Float getFloat(String key) {
        return this.get(key, Float.class);
    }

    public Double getDouble(String key) {
        return this.get(key, Double.class);
    }

    public Character getCharacter(String key) {
        return this.get(key, Character.class);
    }

    public String getString(String key) {
        return this.get(key, String.class);
    }

    public List<?> getList(String key) {
        return this.get(key, List.class);
    }

    public List<Boolean> getBooleanList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object object : list) {
            if (!(object instanceof Boolean)) continue;
            result.add((Boolean)object);
        }
        return result;
    }

    public List<Byte> getByteList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Byte>();
        }
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (Object object : list) {
            if (!(object instanceof Byte)) continue;
            result.add((Byte)object);
        }
        return result;
    }

    public List<Short> getShortList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> result = new ArrayList<Short>();
        for (Object object : list) {
            if (!(object instanceof Short)) continue;
            result.add((Short)object);
        }
        return result;
    }

    public List<Integer> getIntegerList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object object : list) {
            if (!(object instanceof Integer)) continue;
            result.add((Integer)object);
        }
        return result;
    }

    public List<Long> getLongList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object object : list) {
            if (!(object instanceof Long)) continue;
            result.add((Long)object);
        }
        return result;
    }

    public List<Float> getFloatList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> result = new ArrayList<Float>();
        for (Object object : list) {
            if (!(object instanceof Float)) continue;
            result.add((Float)object);
        }
        return result;
    }

    public List<Double> getDoubleList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (Object object : list) {
            if (!(object instanceof Double)) continue;
            result.add((Double)object);
        }
        return result;
    }

    public List<Character> getCharacterList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> result = new ArrayList<Character>();
        for (Object object : list) {
            if (!(object instanceof Character)) continue;
            result.add((Character)object);
        }
        return result;
    }

    public List<String> getStringList(String key) {
        List<?> list = this.getList(key);
        if (list == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : list) {
            if (!(object instanceof String)) continue;
            result.add(String.valueOf(object));
        }
        return result;
    }
}

