/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import java.util.regex.Pattern;

public final class StringUtil {
    public static final Pattern VALID_SQL_PATTERN = Pattern.compile("^[a-zA-Z0-9-_.?!*<>:/]+$");

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.length() >= prefix.length() && str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static <T> T checkArgumentSQL(T value) {
        if (!VALID_SQL_PATTERN.matcher(value.toString()).matches()) {
            throw new IllegalArgumentException("'" + String.valueOf(value) + "' contains invalid characters. Only alphanumerics and -_.?!*<>:/ are allowed.");
        }
        return value;
    }

    public static Object[] checkAllObjects(Object[] objects) {
        Object[] cleanedValues = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            cleanedValues[i] = StringUtil.checkArgumentSQL(objects[i].toString());
        }
        return cleanedValues;
    }
}

