/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.utils;

import de.murmelmeister.murmelapi.playtime.PlayTime;
import de.murmelmeister.murmelapi.playtime.PlayTimeType;

public final class TimeUtil {
    public static long formatTime(String args) {
        if (args.equals("-1")) {
            return -1L;
        }
        if (args.startsWith("-")) {
            return -2L;
        }
        try {
            String format = args.substring(args.length() - 1);
            long duration = Long.parseLong(args.substring(0, args.length() - 1));
            return TimeUtil.getTime(format, duration);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    private static long getTime(String format, long duration) {
        return switch (format) {
            case "s" -> duration * 1000L;
            case "m" -> duration * 1000L * 60L;
            case "h" -> duration * 1000L * 60L * 60L;
            case "d" -> duration * 1000L * 60L * 60L * 24L;
            case "w" -> duration * 1000L * 60L * 60L * 24L * 7L;
            case "M" -> duration * 1000L * 60L * 60L * 24L * 30L;
            case "y" -> duration * 1000L * 60L * 60L * 24L * 365L;
            default -> -3L;
        };
    }

    public static String formatTimeValue(PlayTime playTime, int userId) {
        long seconds = playTime.getTime(userId, PlayTimeType.SECONDS);
        long minutes = playTime.getTime(userId, PlayTimeType.MINUTES);
        long hours = playTime.getTime(userId, PlayTimeType.HOURS);
        long days = playTime.getTime(userId, PlayTimeType.DAYS);
        long years = playTime.getTime(userId, PlayTimeType.YEARS);
        return (String)(years != 0L ? TimeUtil.getTimeValue(years, PlayTimeType.YEARS).replace("365 days", "") + " " : "") + (String)(days != 0L ? TimeUtil.getTimeValue(days, PlayTimeType.DAYS).replace("24 hours", "") + " " : "") + (String)(hours != 0L ? TimeUtil.getTimeValue(hours, PlayTimeType.HOURS).replace("60 minutes", "") + " " : "") + (String)(minutes != 0L ? TimeUtil.getTimeValue(minutes, PlayTimeType.MINUTES).replace("60 seconds", "") + " " : "") + (seconds != 0L ? TimeUtil.getTimeValue(seconds, PlayTimeType.SECONDS) : "");
    }

    public static String formatScoreboardTime(PlayTime playTime, int userId) {
        long hours = playTime.getTime(userId, PlayTimeType.HOURS);
        long days = playTime.getTime(userId, PlayTimeType.DAYS);
        long years = playTime.getTime(userId, PlayTimeType.YEARS);
        return (String)(years != 0L ? TimeUtil.getTimeValue(years, PlayTimeType.YEARS).replace("365 days", "") + " " : "") + (String)(days != 0L ? TimeUtil.getTimeValue(days, PlayTimeType.DAYS).replace("24 hours", "") + " " : "") + (hours != 0L ? TimeUtil.getTimeValue(hours, PlayTimeType.HOURS) : "0 ");
    }

    private static String getTimeValue(long time, PlayTimeType type) {
        return time == 1L ? "1 " + type.getName().replace("s", "").toLowerCase() : time + " " + type.getName().toLowerCase();
    }
}

