/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.group.settings;

import de.murmelmeister.murmelapi.group.settings.GroupColorSettings;
import de.murmelmeister.murmelapi.group.settings.GroupColorType;
import de.murmelmeister.murmelapi.utils.Database;
import java.text.SimpleDateFormat;

public final class GroupColorSettingsProvider
implements GroupColorSettings {
    private static final String TABLE_NAME = "GroupColorSettings";

    public GroupColorSettingsProvider() {
        this.createTable();
        Procedure.loadAll();
    }

    private void createTable() {
        Database.update("CREATE TABLE IF NOT EXISTS %s (GroupID INT PRIMARY KEY, CreatorID INT, EditedTime BIGINT(255), ChatPrefix VARCHAR(300), ChatSuffix VARCHAR(300), ChatColor VARCHAR(30), TabPrefix VARCHAR(300), TabSuffix VARCHAR(300), TabColor VARCHAR(30), TagPrefix VARCHAR(300), TagSuffix VARCHAR(300), TagColor VARCHAR(30))", TABLE_NAME);
    }

    @Override
    public boolean existsGroup(int groupId) {
        return Database.exists("CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public void createGroup(int groupId, int creatorId) {
        this.createGroup(groupId, creatorId, "", "", "", "", "", "", "", "", "&7");
    }

    @Override
    public void createGroup(int groupId, int creatorId, String chatPrefix, String chatSuffix, String chatColor, String tabPrefix, String tabSuffix, String tabColor, String tagPrefix, String tagSuffix, String tagColor) {
        if (this.existsGroup(groupId)) {
            return;
        }
        Database.update("CALL %s('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')", Procedure.PROCEDURE_INSERT.getName(), groupId, creatorId, System.currentTimeMillis(), chatPrefix, chatSuffix, chatColor, tabPrefix, tabSuffix, tabColor, tagPrefix, tagSuffix, tagColor);
    }

    @Override
    public void deleteGroup(int groupId) {
        Database.update("CALL %s('%s')", Procedure.PROCEDURE_DELETE.getName(), groupId);
    }

    @Override
    public int getCreatorId(int groupId) {
        return Database.getInt(-2, "CreatorID", "CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public long getEditedTime(int groupId) {
        return Database.getLong(-1L, "EditedTime", "CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public String getEditedDate(int groupId) {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.getEditedTime(groupId));
    }

    @Override
    public String getPrefix(GroupColorType type, int groupId) {
        return Database.getString(null, type.getName() + "Prefix", "CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public String getSuffix(GroupColorType type, int groupId) {
        return Database.getString(null, type.getName() + "Suffix", "CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public String getColor(GroupColorType type, int groupId) {
        return Database.getString(null, type.getName() + "Color", "CALL %s('%s')", Procedure.PROCEDURE_GROUP_ID.getName(), groupId);
    }

    @Override
    public void setPrefix(GroupColorType type, int groupId, int creatorId, String prefix) {
        String name = switch (type) {
            default -> throw new MatchException(null, null);
            case GroupColorType.CHAT -> Procedure.PROCEDURE_UPDATE_CHAT_PREFIX.getName();
            case GroupColorType.TAB -> Procedure.PROCEDURE_UPDATE_TAB_PREFIX.getName();
            case GroupColorType.TAG -> Procedure.PROCEDURE_UPDATE_TAG_PREFIX.getName();
        };
        Database.update("CALL %s('%s','%s','%s','%s')", name, groupId, creatorId, System.currentTimeMillis(), prefix);
    }

    @Override
    public void setSuffix(GroupColorType type, int groupId, int creatorId, String suffix) {
        String name = switch (type) {
            default -> throw new MatchException(null, null);
            case GroupColorType.CHAT -> Procedure.PROCEDURE_UPDATE_CHAT_SUFFIX.getName();
            case GroupColorType.TAB -> Procedure.PROCEDURE_UPDATE_TAB_SUFFIX.getName();
            case GroupColorType.TAG -> Procedure.PROCEDURE_UPDATE_TAG_SUFFIX.getName();
        };
        Database.update("CALL %s('%s','%s','%s','%s')", name, groupId, creatorId, System.currentTimeMillis(), suffix);
    }

    @Override
    public void setColor(GroupColorType type, int groupId, int creatorId, String color) {
        String name = switch (type) {
            default -> throw new MatchException(null, null);
            case GroupColorType.CHAT -> Procedure.PROCEDURE_UPDATE_CHAT_COLOR.getName();
            case GroupColorType.TAB -> Procedure.PROCEDURE_UPDATE_TAB_COLOR.getName();
            case GroupColorType.TAG -> Procedure.PROCEDURE_UPDATE_TAG_COLOR.getName();
        };
        Database.update("CALL %s('%s','%s','%s','%s')", name, groupId, creatorId, System.currentTimeMillis(), color);
    }

    private static enum Procedure {
        PROCEDURE_GROUP_ID("GroupColorSettings_GroupID", Database.getProcedureQuery("GroupColorSettings_GroupID", "gid INT", "SELECT * FROM %s WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_INSERT("GroupColorSettings_Insert", Database.getProcedureQuery("GroupColorSettings_Insert", "gid INT, creator INT, time BIGINT(255), chatP VARCHAR(300), chatS VARCHAR(300), chatC VARCHAR(30), tabP VARCHAR(300), tabS VARCHAR(300), tabC VARCHAR(30), tagP VARCHAR(300), tagS VARCHAR(300), tagC VARCHAR(30)", "INSERT INTO %s VALUES (gid, creator, time, chatP, chatS, chatC, tabP, tabS, tabC, tagP, tagS, tagC);", "GroupColorSettings")),
        PROCEDURE_DELETE("GroupColorSettings_Delete", Database.getProcedureQuery("GroupColorSettings_Delete", "gid INT", "DELETE FROM %s WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_CHAT_PREFIX("GroupColorSettings_Update_ChatPrefix", Database.getProcedureQuery("GroupColorSettings_Update_ChatPrefix", "gid INT, creator INT, time BIGINT(255), chat VARCHAR(300)", "UPDATE %s SET ChatPrefix=chat, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_CHAT_SUFFIX("GroupColorSettings_Update_ChatSuffix", Database.getProcedureQuery("GroupColorSettings_Update_ChatSuffix", "gid INT, creator INT, time BIGINT(255), chat VARCHAR(300)", "UPDATE %s SET ChatSuffix=chat, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_CHAT_COLOR("GroupColorSettings_Update_ChatColor", Database.getProcedureQuery("GroupColorSettings_Update_ChatColor", "gid INT, creator INT, time BIGINT(255), chat VARCHAR(30)", "UPDATE %s SET ChatColor=chat, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_TAB_PREFIX("GroupColorSettings_Update_TabPrefix", Database.getProcedureQuery("GroupColorSettings_Update_TabPrefix", "gid INT, creator INT, time BIGINT(255), tab VARCHAR(300)", "UPDATE %s SET TabPrefix=tab, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_TAB_SUFFIX("GroupColorSettings_Update_TabSuffix", Database.getProcedureQuery("GroupColorSettings_Update_TabSuffix", "gid INT, creator INT, time BIGINT(255), tab VARCHAR(300)", "UPDATE %s SET TabSuffix=tab, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_TAB_COLOR("GroupColorSettings_Update_TabColor", Database.getProcedureQuery("GroupColorSettings_Update_TabColor", "gid INT, creator INT, time BIGINT(255), tab VARCHAR(30)", "UPDATE %s SET TabColor=tab, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_TAG_PREFIX("GroupColorSettings_Update_TagPrefix", Database.getProcedureQuery("GroupColorSettings_Update_TagPrefix", "gid INT, creator INT, time BIGINT(255), tag VARCHAR(300)", "UPDATE %s SET TagPrefix=tag, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_TAG_SUFFIX("GroupColorSettings_Update_TagSuffix", Database.getProcedureQuery("GroupColorSettings_Update_TagSuffix", "gid INT, creator INT, time BIGINT(255), tag VARCHAR(300)", "UPDATE %s SET TagSuffix=tag, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings")),
        PROCEDURE_UPDATE_TAG_COLOR("GroupColorSettings_Update_TagColor", Database.getProcedureQuery("GroupColorSettings_Update_TagColor", "gid INT, creator INT, time BIGINT(255), tag VARCHAR(30)", "UPDATE %s SET TagColor=tag, CreatorID=creator, EditedTime=time WHERE GroupID=gid;", "GroupColorSettings"));

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String query) {
            this.name = name;
            this.query = query;
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public static void loadAll() {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

