/*
 * Decompiled with CFR 0.152.
 */
package de.murmelmeister.murmelapi.bansystem.mute;

import de.murmelmeister.murmelapi.bansystem.log.Log;
import de.murmelmeister.murmelapi.bansystem.log.LogProvider;
import de.murmelmeister.murmelapi.bansystem.mute.Mute;
import de.murmelmeister.murmelapi.bansystem.reason.Reason;
import de.murmelmeister.murmelapi.bansystem.reason.ReasonProvider;
import de.murmelmeister.murmelapi.utils.Database;

public final class MuteProvider
implements Mute {
    private final String tableName = "Mute_List";
    private final Reason reason = new ReasonProvider("Mute_Reason");
    private final Log log = new LogProvider("Mute_Log", this.reason);

    public MuteProvider() {
        this.createTable();
        Procedure.loadAll("Mute_List");
    }

    private void createTable() {
        Database.update("CREATE TABLE IF NOT EXISTS %s (UserID INT, ExpiredTime BIGINT(255))", "Mute_List");
    }

    @Override
    public void mute(int userId, int creatorId, int reasonId, long time) {
        int logId = this.log.addLog(userId, creatorId, reasonId, time);
        Database.updateCall(Procedure.PROCEDURE_MUTE_ADD.getName(), userId, this.log.getExpiredTime(logId));
    }

    @Override
    public void unmute(int userId) {
        Database.updateCall(Procedure.PROCEDURE_MUTE_REMOVE.getName(), userId);
    }

    @Override
    public long getExpiredTime(int userId) {
        return Database.getLongCall(-2L, "ExpiredTime", Procedure.PROCEDURE_MUTE_GET.getName(), userId);
    }

    @Override
    public boolean isMuted(int userId) {
        long time = this.getExpiredTime(userId);
        return time == -1L || time >= System.currentTimeMillis();
    }

    @Override
    public Reason getReason() {
        return this.reason;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    private static enum Procedure {
        PROCEDURE_MUTE_ADD("Mute_Add", "uid INT, expired BIGINT(255)", "INSERT INTO %s VALUES (uid, expired);", new Object[0]),
        PROCEDURE_MUTE_REMOVE("Mute_Remove", "uid INT", "DELETE FROM %s WHERE UserID=uid;", new Object[0]),
        PROCEDURE_MUTE_GET("Mute_Get", "uid INT", "SELECT * FROM %s WHERE UserID=uid;", new Object[0]);

        private static final Procedure[] VALUES;
        private final String name;
        private final String query;

        private Procedure(String name, String input, String query, Object ... objects) {
            this.name = name;
            this.query = Database.getProcedureQuery(name, input, query, objects);
        }

        public String getName() {
            return this.name;
        }

        public String getQuery(String tableName) {
            return String.format(this.query, tableName);
        }

        public static void loadAll(String tableName) {
            for (Procedure procedure : VALUES) {
                Database.update(procedure.getQuery(tableName), new Object[0]);
            }
        }

        static {
            VALUES = Procedure.values();
        }
    }
}

